maskat.lang.Class.declare("maskat.widget.rialto.GridWrapper")
	.extend("maskat.widget.rialto.RialtoWidgetWrapper", {

    createWidget: function(parent) {
		this.TabEntete = [];
		this.tabTypeCol = [];
    
    	if (this.headers) {
    		for (var i = 0; i < this.headers.length; i++) {
    			var header = this.headers[i];
    			this.TabEntete.push(header.title);
    			this.tabTypeCol.push([header.type, header.width, header.tabData]);
    		}
    	}

		var grid = new rialto.widget.Grid(this);

		if(typeof(this.onCellEdit) != "undefined"){
	    	grid.onCellEdit = this.onCellEdit;
	    }
		
		var self = this;
		grid.onclick = function() { self.notifyEvent("onclick"); };
		grid.ondbleclick = function() { self.notifyEvent("ondbleclick"); };
		grid.onCellWrite = function() { self.notifyEvent("onCellWrite"); };
    		
		this.widget = grid;
		return this.widget;
    },

	postCreateWidget: function() {
		this.widget.divExt.tabIndex = -1;
		this.addKeyEventListener(this.widget.divExt);

		/* グリッドの初期ソート状態を設定 */
		if (this.sortable) {
			this.widget.triColonne(this.sortCol, this.boolOrder);
		}

		/* グリッドの初期データ (gridLine/gridCell) を登録 */
		this.setTabData(this.tabData);
	},

	setTabData: function(data) {
		if (data) {
			/*
			 * グリッドがソートされている場合、データ更新後も現在のソート
			 * 状態を保存する
			 */
			var oldColCLic = this.widget.oldColCLic;
			if (oldColCLic) {
				this.widget.fillGrid(data, oldColCLic.ind, oldColCLic.boolOrder);
			} else {
				this.widget.fillGrid(data);
			}

			var index = this.getTabIndex();
			for (var i = 0; i < this.widget.tableauHTML.childNodes.length; i++) {
				if (this.widget.cellActive) {
					var nodes = this.widget.tableauHTML.childNodes[i];
					for (var j = 0; j < nodes.childNodes.length; j++) {
						if (nodes.childNodes[j].className == "grid_cellData") {
							nodes.childNodes[j].tabIndex = index;
						}
					}
				} else {
					this.widget.tableauHTML.childNodes[i].tabIndex = index;
				}
			}
		}
	},

	getValue: function(key) {
		if (key && this.getters[key]) {
			return this.getters[key].call(this);
		}
		return this.widget.tabData;
	},

	getters: {
		selectedIndex: function() {
			return this.widget.indLineClic;
		},

		selectedIndexes: function() {
			var indexes = []
			var tabData = this.widget.tabData;
			for (var i = 0; i < tabData.length; i++) {
				if (tabData[i].sel) {
					indexes.push(i);
				}
			}
			return indexes;
		}
	},

	setValue: function(value, key) {
		
		if(typeof(value) != "undefined"){
			
			for(i=0;i < value.length;i++){
				var tabdata = value[i];
				
				for(j=0;j < this.widget.tabEntete.length;j++){
					if(typeof(tabdata[j])=="undefined"){
						tabdata[j]="";
					}
				}		
			}
		
		}else{
			this.clear();
		}
	
	
		if (key && this.setters[key]) {
			this.setters[key].call(this, value);
		}
		this.setTabData(value);
	},
	
	setters: {
	},

	clear: function() {
		this.widget.initTab();
	},

	handleKeyEvent: function(event) {
		var element = event.target || event.srcElement;
		var line = parseInt(this.widget.getLineIndex(element), 0);
		if (line == -1) {
			return true;
		}
		if (this.widget.cellActive) {
			var col = parseInt(this.widget.getCellIndex(element), 10);
			if (this.widget.NbreCol - 1 > 0 && col < 0) {
				col = 0;
			}
			switch (event.keyCode) {
			case 13:
			case 32:
				this.widget.afterOnClick(line, col);
				break;
			case 37:
				if (0 < col) {
					this.widget.getHtmlCellFromIndex(line, col - 1).focus();
				}
				break;
			case 38:
				if (0 < line) {
					this.widget.getHtmlCellFromIndex(line - 1, col).focus();
				}
				break;
			case 39:
				if (this.widget.NbreCol - 1 > col) {
					this.widget.getHtmlCellFromIndex(line, col + 1).focus();
				}
				break;
			case 40:
				if (this.widget.NbreLig - 1 > line) {
					this.widget.getHtmlCellFromIndex(line + 1, col).focus();
				}
				break;
			default:
				return true;
			}
		} else {
			switch (event.keyCode) {
			case 13:
			case 32:
				this.widget.afterOnClick(line, col);
				break;
			case 38:
				if (0 < line) {
					this.widget.getHtmlLineFromIndex(line - 1).focus();
				}
				break;
			case 40:
				if (this.widget.NbreLig - 1 > line) {
					this.widget.getHtmlLineFromIndex(line + 1).focus();
				}
				break;
			default:
				return true;
			}
		}
		return false;
	},
	
	setFocus: function() {
		if (this.widget.NbreLig > 0) {
			if (this.widget.cellActive) {
				if (this.widget.NbreCol > 0) {
					this.widget.tableauHTML.childNodes[0].
						childNodes[1].focus();
				}
			} else {
				this.widget.tableauHTML.childNodes[0].focus();
			}
		} else {
			this.widget.tableauHTML.focus();
		}
	}
});
