#include "HPLQuickSort.h"
#include "HPLMath.h"

/////////////////////////////////////////////////////////////////////////////
//////////////  Static Methods  /////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

template<class T>
void exchangePair(struct hpl::math::qsort::Pair<T> *data1, 
                  struct hpl::math::qsort::Pair<T> *data2)
{
    struct hpl::math::qsort::Pair<T> temp;
    temp.index = data1->index;
    temp.data = data1->data;
}
/**
    w肵l傫Aŕ܂
    divide [more than axis] and [less than axis]
    -smaller is left, bigger is right
    -return offset of start of biggers
*/
template<class T>
int partition(struct hpl::math::qsort::Pair<T> *dataArray, int start, int end, T axis)
{
    int left = start, right = end;
    while( left <= right){
        while(left <= end && dataArray[left].data < axis)left ++;
        while(right >= start && dataArray[right].data >= axis)right --;
        if(left > right)break;
        //
        hpl::math::exchange<struct hpl::math::qsort::Pair<T> >(&dataArray[left], &dataArray[right]);
    }
    return left;
}

/**
    猩ƂAŏ̒l傫邩A邩𔻒肵܂
    傫ꍇ͍ŏ̈ʒuA
    ꍇ͂̏ꏊl̃CfbNXƂ܂B
    select axis-num 
    -find two different nums from indexes' left
    -return bigger one
    -if all nums are equal, return -1
*/
template<class T>
int pivot(struct hpl::math::qsort::Pair<T> *dataArray, int start, int end)
{
    //start̉Eׂn߂Bstart̐llƂB
    int k = start + 1;

    //startƈقȂ鐔lo܂Œׂ
    while( k <= end && dataArray[start].data == dataArray[k].data){
        k ++;
    }
    //Sēłꍇi邢͗vfȂ(end == start)ꍇj
    if(k > end){
        return -1;
    }

    if(dataArray[start].data >= dataArray[k].data){
        //kԖڂ̒ll傫ꍇ
        //l̏ꏊԂil`k͑j
        return start;
    }else{
        //l菬ꍇ͂̏ꏊƂ
        return k;
    }
}

/**
    NCbN\[g߂ċNł
    @param indexes f[^
    @param start,end \[g͈
*/
template<class T>
void repeatbleQuickSort(struct hpl::math::qsort::Pair<T> *dataArray, int start, int end)
{
    //ԂI
    if( start == end){
        return;
    }
    int p = pivot(dataArray, start, end);

    //p-1iSēlAj
    if(p != -1){
        //w肳ꂽlɕ܂
        int offset = partition(dataArray, start, end, dataArray[p].data);
        repeatbleQuickSort(dataArray, start, offset - 1);
        repeatbleQuickSort(dataArray, offset, end);
    }
}

/////////////////////////////////////////////////////////////////////////////
//////////////  Global Methods  /////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

template<class T>
void hpl::math::qsort::quickSort(struct hpl::math::qsort::Pair<T> *dataArray, int max)
{
    if(max == 1){
        dataArray[0].index = 0;
    }else{
        //init indexes
        for(int i = 0; i < max; i ++){
            dataArray[i].index = i;
        }
        //\[gJn <en> sort it
        repeatbleQuickSort(dataArray, 0, max - 1);
    }
}

template void hpl::math::qsort::quickSort(struct hpl::math::qsort::Pair<int> *dataArray, int max);
template void hpl::math::qsort::quickSort(struct hpl::math::qsort::Pair<double> *dataArray, int max);
