package jp.hpl.gui.thread;

import javax.swing.JOptionPane;

import jp.hpl.data.DefaultMarathonDataModel;
import jp.hpl.gui.IMapViewerFrame;
import src.gui.Model;

/**
 * thread for loading map
 * @author koji
 *
 */
public class ProgressLoadThread extends Thread {
    DefaultMarathonDataModel model;
    String openFile;

    public ProgressLoadThread(DefaultMarathonDataModel model, String openFile){
        this.model = model;
        this.openFile = openFile;
    }

    public void run(){
        try{
            model.openMapFile(openFile);
            model.initLoad();
            model.turnProgOff();
            

        } catch(Exception e){
//            System.out.println("Problem opening map file");
            JOptionPane.showMessageDialog(null, "Problem opening map file");
            model.turnProgOff();
        }
    }

}
