package jp.hpl.gui.render;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;

import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

import jp.hpl.gui.IMapViewerFrame;

import src.backend.Level;

/**
 * Render Canvas
 * @author koji
 *
 */
public class RenderCanvas extends JPanel implements MouseInputListener, KeyListener{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * datas for draw
	 */
	private Level levelForDraw;
	
	/** dimension transformer */
	private Transformer transformer;
	private static final double MOUSE_DRAG_TURN_SPEED = 0.1;
	private static final double KEYBORD_SPEED_ROTATE = 3;
	private static final double KEYBORD_SPEED = 5;
	
//	double MAX = 500.0;
	public static final double RATE = 2000.0 / (double)Short.MAX_VALUE;
	double RANGE = 100.0;
	Point previousPoint = new Point();
	
	LineRenderer lineRenderer;
	
	IMapViewerFrame parent;
	
//	JFrame parent;
	public RenderCanvas(IMapViewerFrame parent, Level l){
		setDoubleBuffered(true);
		levelForDraw = l;
		transformer = new Transformer();
		this.parent = parent;
		
		//level情報からプレイヤーの位置を取得
		
		double[] playerPosition3D = {0.0,50.0,-150.0};
		double phi = 0;
//		try{
//			ObjsEntry player = StaticData.getPlayer(levelForDraw);
//			
//			playerPosition3D[0] = player.getX() * RenderCanvas.RATE;
//			playerPosition3D[1] = player.getZ() * RenderCanvas.RATE;
//			playerPosition3D[2] = player.getY() * RenderCanvas.RATE;
//			
//			int facing = player.getFacing();
//			phi = (double)facing / 512.0 * 2 * Math.PI;
//			
//			//set camera
//			Point p = parent.getCanvas().getViewPointFromWorldPoint(
//					(short)(player.getX() * StaticData.WORLD_ONE),
//					(short)(player.getY() * StaticData.WORLD_ONE));
			int c[] = parent.getCanvas().getCameraPosition();
			playerPosition3D[0] = (double)c[0] * RenderCanvas.RATE;
			playerPosition3D[2] = (double)c[1] * RenderCanvas.RATE;
			playerPosition3D[1] = (double)c[2] * RenderCanvas.RATE;
//			parent.setCameraCenter((short)(c[0] * RenderCanvas.RATE),
//					(short)(c[1] * RenderCanvas.RATE));
//		}catch (NoPlayerException e) {
//			
//		}
		
		
		
//		transformer.getCamera().setCenter(0.0,50.0,-150.0);
		transformer.getCamera().setCenter(playerPosition3D);
		transformer.getCamera().setTheta(-0.0*Math.PI/180.0);
		transformer.getCamera().setPhi(phi);
		transformer.doCalcTransformArray();
		
		lineRenderer = new LineRenderer(transformer, levelForDraw, this);
		
//		this.parent = parent;
//		setSize(parent.getSize());
		
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		this.addKeyListener(this);
		this.setEnabled(true);
		this.setFocusable(true);
//		this.addMouseMotionListener(new MouseMotionListener(){
//			public void mouseDragged(MouseEvent e){
//				
//			}
//			public void mouseMoved(MouseEvent e){
//				
//			}
//		});
	}
	

	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
		
//		g.drawLine(0,0,100,100);
		
		setupSize();
		
		lineRenderer.draw(this, g);
		
		//draw console
		Camera camera = transformer.getCamera();
		double[] cameraPosition3D = camera.getCenter();
		g.drawString("Center:" + cameraPosition3D[0] + "," + cameraPosition3D[1] + "," + cameraPosition3D[2],
				0,20);
		g.drawString("Theta:" + camera.getTheta() * 180.0 / Math.PI + " Phi:" + camera.getPhi() * 180.0 / Math.PI,
				0, 30);
		
//		drawVerticalLines(g);
	}

	public void setupSize() {
		int width = this.getWidth();
		int height = this.getHeight();
		transformer.setViewSize(width, height, -RANGE, RANGE, -RANGE, RANGE);
	}

//	private void drawVerticalLines(Graphics g) {
//		for(int i = 0; i < levelForDraw.getEpntChunk().getNumEntries(); i ++){
//			//search lines include this point
//			List includeLines = getLinesIncludeTheEndpoint(levelForDraw.getLinsChunk(), i);
//			if()
//		}
//	}
//

//	private void drawLines(Graphics g) {
//		
//		List alreadyLinedEndpointEnties = new ArrayList();
//		
//		for(int i = 0; i < levelForDraw.getLinsChunk().getNumEntries(); i ++){
//			//horizontal
//			if(!drawHorizontalLines(g, i)){
//				continue;
//			}
//			
//			//vertical
//			drawVerticalLines(g, i, alreadyLinedEndpointEnties);
//		}
//	}

	
	public void mouseClicked(MouseEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void mouseEntered(MouseEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void mouseExited(MouseEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void mousePressed(MouseEvent e) {
		previousPoint = e.getPoint();
	}

	public void mouseReleased(MouseEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void mouseDragged(MouseEvent e) {
		Point p = e.getPoint();
		Camera camera = this.transformer.getCamera();
		double theta = camera.getTheta() +
			Math.PI / 180.0 * (double)(p.y - previousPoint.y) * MOUSE_DRAG_TURN_SPEED;
		double phi = camera.getPhi() +
			Math.PI / 180.0 * (double)(p.x - previousPoint.x) * MOUSE_DRAG_TURN_SPEED;
		camera.setTheta(theta);
		camera.setPhi(phi);
		transformer.doCalcTransformArray();
		repaint();
		
		previousPoint = p;
	}

	public void mouseMoved(MouseEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void keyPressed(KeyEvent arg0) {
		Camera camera = this.transformer.getCamera();
		double[] center = camera.getCenter();
		double phi = camera.getPhi();
		
		boolean isRepaint = false;
		
		if(arg0.getKeyCode() == KeyEvent.VK_UP){
			center[0] += Math.sin(-phi) * KEYBORD_SPEED;
			center[2] += Math.cos(-phi) * KEYBORD_SPEED;
			camera.setCenter(center);
			isRepaint = true;
			
		}else if(arg0.getKeyCode() == KeyEvent.VK_DOWN){
			center[0] -= Math.sin(-phi) * KEYBORD_SPEED;
			center[2] -= Math.cos(-phi) * KEYBORD_SPEED;
			camera.setCenter(center);
			isRepaint = true;
			
		}else if(arg0.getKeyCode() == KeyEvent.VK_LEFT){
			phi += Math.PI / 180.0 * KEYBORD_SPEED_ROTATE;
			camera.setPhi(phi);
			isRepaint = true;
			
		}else if(arg0.getKeyCode() == KeyEvent.VK_RIGHT){
			phi -= Math.PI / 180.0 * KEYBORD_SPEED_ROTATE;
			camera.setPhi(phi);
			isRepaint = true;
			
		}else if(arg0.getKeyCode() == KeyEvent.VK_A){
			center[1] += KEYBORD_SPEED;
			camera.setCenter(center);
			isRepaint = true;
			
		}else if(arg0.getKeyCode() == KeyEvent.VK_Z){
			center[1] -= KEYBORD_SPEED;
			camera.setCenter(center);
			isRepaint = true;
			
		}
		
		if(isRepaint){
			transformer.doCalcTransformArray();
			//camera to canvas
			double[] center1 = camera.getCenter();
			int[] c = {
				(int)(center1[0] / RenderCanvas.RATE),
				(int)(center1[2] / RenderCanvas.RATE),
				(int)(center1[1] / RenderCanvas.RATE),
			};
			parent.getCanvas().setCameraPosition(c);
			parent.getCanvas().setCameraDirectionRadian(phi);
			repaint();
		}
	}

	public void keyReleased(KeyEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void keyTyped(KeyEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}
}
