package jp.hpl.gui.render;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.swing.JComponent;

import jp.hpl.data.StaticData;
import jp.hpl.exception.IntegerOverFlowException;

import src.backend.EpntEntry;
import src.backend.Level;
import src.backend.LinsChunk;
import src.backend.LinsEntry;
import src.backend.StaticFunctions;

public class LineRenderer extends AbstractRenderer {
	Map verticalHeightInformationMap;
	JComponent parent;
	
	public LineRenderer(Transformer tr, Level level, JComponent parent) {
		super(tr, level);
		this.parent = parent;
		verticalHeightInformationMap = new HashMap();
		
		for(int l = 0; l < levelForDraw.getLinsChunk().getNumEntries(); l ++){
			LinsEntry line = levelForDraw.getLinsChunk().getEntry(l);
			short rightPolyIndex = line.getClockwisePolyOwner();
			short leftPolyIndex = line.getCounterClockwisePolyOwner();
			if(rightPolyIndex != StaticData.NONE && leftPolyIndex != StaticData.NONE){
				continue;
			}
			short[] endpointIndex = line.getEndpoints();
			for(int i = 0; i < endpointIndex.length; i ++){
				int entry = endpointIndex[i];
				if(verticalHeightInformationMap.containsKey(Integer.valueOf(entry))){
				//alreadyLinedEndpointEnties.contains(Integer.valueOf(entry))){
					continue;
				}
				
				int ceiling = Short.MIN_VALUE;
				int floor = Short.MAX_VALUE;
				for(int j = 0; j < levelForDraw.getLinsChunk().getNumEntries(); j ++){
					LinsEntry otherLine = levelForDraw.getLinsChunk().getEntry(j);
					if(otherLine.getEndpoints()[0] == entry || otherLine.getEndpoints()[1] == entry){
						int lowestCeiling = otherLine.getLowestAdjacentCeiling();
						int highestFloor = otherLine.getHighestAdjacentFloor();
						if(floor > highestFloor){
							floor = highestFloor;
						}
						if(ceiling < lowestCeiling){
							ceiling = lowestCeiling;
						}
					}
					
				}
				
				//draw the line
	//			double[] 
	//			List includedLines = getLinesIncludeTheEndpoint(levelForDraw.getLinsChunk(),
	//					endpointIndex[i]);
				
//				alreadyLinedEndpointEnties.add(Integer.valueOf(endpointIndex[i]));
				Integer[] minMaxHeight = new Integer[2];
				minMaxHeight[0] = new Integer(floor);
				minMaxHeight[1] = new Integer(ceiling);
				verticalHeightInformationMap.put(Integer.valueOf(entry), 
						minMaxHeight);
			}
		}
	}

	public void draw(JComponent canvas, Graphics g) {
//		List alreadyLinedEndpointEnties = new ArrayList();
		
		//vertical
		drawVerticalLines(g);
		
		for(int i = 0; i < levelForDraw.getLinsChunk().getNumEntries(); i ++){
			//horizontal
			if(!drawHorizontalLine(g, i)){
				continue;
			}
			
		}
	}
	/**
	 * draw vertical lines
	 * @param g
	 * @param entrty
	 * @param alreadyLinedEndpointEnties
	 */
	private void drawVerticalLines(Graphics g){
		Iterator it = verticalHeightInformationMap.keySet().iterator();
		while(it.hasNext()){
			Integer epEntryIndex = (Integer)it.next();
			Integer[] minMax = (Integer[])verticalHeightInformationMap.get(epEntryIndex);
			
			EpntEntry epEntry = levelForDraw.getEpntChunk().getEntry(epEntryIndex.intValue());
			double[][] point3Ds = new double[2][3];
			for(int i = 0; i < minMax.length; i ++){
				double[] temp = new double[3];
				temp[0] = (double)epEntry.getVertex()[0] * RenderCanvas.RATE;
				temp[1] = (double)minMax[i].intValue() * RenderCanvas.RATE;
				temp[2] = (double)epEntry.getVertex()[1] * RenderCanvas.RATE;
				point3Ds[i] = transformer.get3DView(temp);
			}
			
			if(!drawLine(point3Ds, g)){
				continue;
			}
		}
	}
	
	private boolean drawLine(double[][] point3Ds, Graphics g) {
		boolean isBackward[] = new boolean[2];
		for(int j = 0; j < isBackward.length; j ++){
			isBackward[j] = (point3Ds[j][2] < 0);
		}
		if(isBackward[0] && isBackward[1]){
			return false;
		}else{
			for(int j = 0; j < isBackward.length; j ++){
				if(isBackward[j]){
					point3Ds[j][2] = 0;
				}
			}
		}
		
		try{
			int[][] viewPoint2D = new int[2][2];
			for(int j = 0; j < point3Ds.length; j ++){
				double[] peredPoint = transformer.getPers(point3Ds[j]);
				viewPoint2D[j] = transformer.getViewPoint(peredPoint);
			}
			if(!this.parent.getBounds().contains(viewPoint2D[0][0], viewPoint2D[0][1]) &&
					!this.parent.getBounds().contains(viewPoint2D[1][0], viewPoint2D[1][1])
					){
				return false;
			}
			g.drawLine(viewPoint2D[0][0], viewPoint2D[0][1], viewPoint2D[1][0], viewPoint2D[1][1]);
		}catch (Exception e) {
			return false;
		}
		return true;
	}

//	/**
//	 * search all lines include the point
//	 * @param linsChunk chunks of "Lins"
//	 * @param entry the index of endpoint
//	 * @returns
//		//list of line entries (index)
//		List lines = new ArrayList();
//		
//		for(int i = 0; i < levelForDraw.getLinsChunk().getNumEntries(); i ++){
//			LinsEntry line = levelForDraw.getLinsChunk().getEntry(i);
//			if(line.getEndpoints()[0] == entry || line.getEndpoints()[1] == entry){
//				lines.add(line);
//			}
//		}
//		return lines;
//	}

	/**
	 * 
	 * @param g
	 * @param entrty
	 * @return did succeeded to draw the line?
	 */
	private boolean drawHorizontalLine(Graphics g, int entrty) {
		LinsEntry line = levelForDraw.getLinsChunk().getEntry(entrty);
		short[] endpointIndex = line.getEndpoints();
		
//		try{
			double[] heights = {
					line.getHighestAdjacentFloor(),
					line.getLowestAdjacentCeiling(),
			};
			
			
			for(int floorAndHeight = 0; floorAndHeight < heights.length; floorAndHeight ++){
				double[][] point3Ds = new double[2][3];
				
				for(int e = 0; e < endpointIndex.length; e ++){
					EpntEntry endpoint = levelForDraw.getEpntChunk().getEntry(endpointIndex[e]);
					short[] pointWorld2D = endpoint.getVertex();
					double[] pointWorld3DAdjust = new double[3];
					pointWorld3DAdjust[0] = (double)pointWorld2D[0] * RenderCanvas.RATE;
					pointWorld3DAdjust[1] = heights[floorAndHeight] * RenderCanvas.RATE;
					pointWorld3DAdjust[2] = (double)pointWorld2D[1] * RenderCanvas.RATE;
					point3Ds[e] = transformer.get3DView(pointWorld3DAdjust);
				}
				if(!drawLine(point3Ds, g)){
					continue;
				}
			}
//		}catch (IntegerOverFlowException e){
//			return false;
//		}
		return true;
	}

}
