package jp.hpl.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

import src.backend.EpntEntry;
import src.backend.GetFile;
import src.backend.Level;
import src.backend.LinsEntry;
import src.backend.MapData;
import src.backend.ObjsEntry;
import src.backend.PolyEntry;

import jp.hpl.data.StaticData;
import jp.hpl.exception.NoPlayerException;
import jp.hpl.gui.render.RenderCanvas;

/**
 * main canvas that draws lines, points, polygons, and so on.
 * @author koji
 *
 */
public class MapCanvas extends JPanel implements MouseInputListener, KeyListener,
	MouseWheelListener{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static final double DRAG_ZOOM_STEP = 0.1;
	
	/** manage scroll offset and zoom for view */
	private Scroller scroller;
	
	
	private static int MENUBAR_HEIGHT = 20;
	private static int FONT_HEIGHT = 12;
	
	private Level levelForDraw = null;
	
	private Point dragStartPoint;
	private boolean isCtrlPressed = false;
	
	Map mapIconList = new HashMap();
	
	private JFrame parent;
	
//	List mapIconImageFileNameList
	private static String MAP_ICON_IMAGE_LIST_FILE_PATH = StaticData.RESOURCES_DIR_PATH + 
		"MapIconImageList.txt";
	private static String MAP_ICONS_DIR_PATH = StaticData.RESOURCES_DIR_PATH +
		"Map Icons/";
	private static String MAP_ICONS_HIGHLIGHTED_DIR_PATH = MAP_ICONS_DIR_PATH +
		"Highlighted/";
	
	private static String MAP_ICONS_CAMERA_POSITION_IMAGE_FILE_NAME = "center X.png";
	private Image mapIconCemraPositionImage;
	
	/** camera center position */
	int[] cameraPosition = {0,0,0};
	double cameraDirectionRadian = 0;
	
	ToolbarDialog toolbarDialog;
	
	/**
	 * 
	 * @param p
	 */
	public MapCanvas(JFrame p){
		setDoubleBuffered(true);
		setBackground(Color.white);
		scroller = new Scroller();
		dragStartPoint = new Point();
//		toolbarDialog = toolbar;
		
		parent = p;
		
		
		
		//load images
		try {
//			ImageReader ir = (ImageReader)ImageIO.getImageReadersByFormatName("png").next();
			BufferedReader br = new BufferedReader(new FileReader(
					MAP_ICON_IMAGE_LIST_FILE_PATH));
			String line = "";
			int type = 0;
			while((line = br.readLine()) != null){
				if(line.equals("")){
					continue;
				}
//				mapIconList.add(line);
				String path = 
					MAP_ICONS_DIR_PATH + line;
				StaticData.logln(path);
//				URL u = MapCanvas.class.getResource(path);
//				ImageInputStream iis = ImageIO.createImageInputStream(new File(path));
//				ir.setInput(iis, true);
				
				Image img = Toolkit.getDefaultToolkit().getImage(path);
//				BufferedImage bimg = new BufferedImage(img.getWidth(this), img.getHeight(this),
//						BufferedImage.TYPE_4BYTE_ABGR);
//				bimg.createGraphics().drawImage(img, 0, 0, this);
				
//				Image img = iis.
				mapIconList.put((Object)(Integer.valueOf(type)), (Object)img);
				type ++;
			}
			br.close();
			
			String path = MAP_ICONS_DIR_PATH +
				MAP_ICONS_CAMERA_POSITION_IMAGE_FILE_NAME;
			mapIconCemraPositionImage = Toolkit.getDefaultToolkit().getImage(path);
		} catch (FileNotFoundException e) {
			System.err.println("cannot find map icon image list");
			e.printStackTrace();
		} catch (IOException e) {
			System.err.println("cannot load map icon image list");
			e.printStackTrace();
		}
		
		this.addKeyListener(this);
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		this.addMouseWheelListener(this);
		this.setEnabled(true);
		this.setFocusable(true);
	}
	
//	@Override
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
//		g.drawOval(10, 10, 100, 100);
		
		//outter frame
		this.drawMainFrame(g);
		
		//grid lines
		
		
		if(levelForDraw != null){
			//polygons
			this.drawPolygons(g);
			
			//lines
			this.drawLines(g);
			
			//endpoints
			this.drawEndpoints(g);
			
			//objects
			this.drawObjects(g);
			
			//camera position
			Point p = getViewPointFromWorldPoint((short)cameraPosition[0], (short)cameraPosition[1]);
			drawTriangle(-this.cameraDirectionRadian + Math.PI / 2.0, p.x, p.y, Color.blue, g);
			g.drawImage(mapIconCemraPositionImage, p.x, p.y,
					this);
			
			//level name
			g.setColor(Color.black);
			g.drawString(levelForDraw.getlevelSelectName(), 0, MENUBAR_HEIGHT);
		}
		
		// console
		Point offset = this.scroller.getOffset();
		g.drawString("Offset:" + offset.x + "," + offset.y, 0, MENUBAR_HEIGHT + FONT_HEIGHT);
		g.drawString("Zoom:" + this.scroller.getZoom(), 0, MENUBAR_HEIGHT + FONT_HEIGHT * 2);
		g.drawString("Camera:" + cameraPosition[0] + "," + cameraPosition[1] + "," + cameraPosition[2],
				0, MENUBAR_HEIGHT + FONT_HEIGHT * 3);

	}

	/**
	 * draw endpoints 
	 * @param g
	 */
	private void drawEndpoints(Graphics g) {
		for(int i = 0; i < levelForDraw.getEpntChunk().getNumEntries(); i ++){
			EpntEntry endpoint = levelForDraw.getEpntChunk().getEntry(i);
			short[] vertex = endpoint.getVertex();
			Point point = getViewPointFromWorldPoint(vertex[0], vertex[1]);
			if(!this.getBounds().contains(point)){
				continue;
			}
			
			g.setColor(Color.blue);
			g.fillRect(
					point.x - StaticData.ENDPOINT_RECT_SIZE / 2, 
					point.y - StaticData.ENDPOINT_RECT_SIZE / 2,
					StaticData.ENDPOINT_RECT_SIZE, 
					StaticData.ENDPOINT_RECT_SIZE);
		}
	}

	/**
	 * draw polygons 
	 * @param g
	 */
	private void drawPolygons(Graphics g) {
		for(int i = 0; i < levelForDraw.getPolyChunk().getNumEntries(); i ++){
			PolyEntry poly = levelForDraw.getPolyChunk().getEntry(i);
			short[] endpoints = poly.getEndpoint_indexes();
			int vertexCount = poly.getVertex_count();
			
			int[] x = new int[vertexCount];
			int[] y = new int[vertexCount];
			boolean isInRegion = false;
			for(int endpointEntryIndex = 0; endpointEntryIndex < vertexCount; endpointEntryIndex ++){
				EpntEntry endpoint = levelForDraw.getEpntChunk().getEntry(
						endpoints[endpointEntryIndex]);
				short[] vertex = endpoint.getVertex();
				Point vp = getViewPointFromWorldPoint(vertex[0], vertex[1]);
				if(this.getBounds().contains(vp)){
					isInRegion = true;
				}
				x[endpointEntryIndex] = vp.x;
				y[endpointEntryIndex] = vp.y;
			}
			if(!isInRegion){
				continue;
			}
			//draw
			g.setColor(Color.gray);
			g.fillPolygon(x, y, vertexCount);
		}
	}
	
	/**
	 * draw objects
	 * @param g
	 */
	private void drawObjects(Graphics g) {
		
		for(int i = 0; i < levelForDraw.getObjsChunk().getNumEntries(); i ++){
			ObjsEntry obj = levelForDraw.getObjsChunk().getEntry(i);
			short worldX = (short)(obj.getX() * StaticData.WORLD_ONE);
			short worldY = (short)(obj.getY() * StaticData.WORLD_ONE);
			
			int subtype = obj.getSubtype();
			int type = obj.getType();
			
			Point v = getViewPointFromWorldPoint(worldX, worldY);
			
			if(!this.getBounds().contains(v)){
				continue;
			}
			switch(type){
			case StaticData.OBJS_SUBTYPE_MONSTER:
			case StaticData.OBJS_SUBTYPE_PLAYER:
				int facing = obj.getFacing();
				double rad = (double)facing / 512.0 * 2 * Math.PI;
				Color col = Color.red;
				if(type == StaticData.OBJS_SUBTYPE_PLAYER){
					//g.setColor(Color.yellow);
					col = Color.yellow;
				}else{
//					g.setColor(Color.red);
				}
				drawTriangle(rad, v.x, v.y, col, g);
				break;
			case StaticData.OBJS_SUBTYPE_ITEMS:
				g.drawImage((Image)mapIconList.get(Integer.valueOf(subtype)), v.x, v.y, this);
				break;
			case StaticData.OBJS_SUBTYPE_GOALS:
				g.drawImage((Image)mapIconList.get(Integer.valueOf(StaticData.OBJS_MAP_ICON_GOALS_IMAGE_INDEX)), v.x, v.y, this);
				break;
			case StaticData.OBJS_SUBTYPE_SCENERY:
				g.drawImage((Image)mapIconList.get(Integer.valueOf(StaticData.OBJS_MAP_ICON_SCENERY_IMAGE_INDEX)), v.x, v.y, this);
				break;
			case StaticData.OBJS_SUBTYPE_SOUNDS:
				g.drawImage((Image)mapIconList.get(Integer.valueOf(StaticData.OBJS_MAP_ICON_SOUND_IMAGE_INDEX)), v.x, v.y, this);
				break;
			default:
//				throw new RuntimeException("unsupported object subtype:" + subtype);
				
			}

		}
	}

	private void drawTriangle(double rad, int pointX, int pointY, Color col,
			Graphics g) {
		final int LENGTH = 10;
		final int WING_LENGTH = 5;
		final double WING_RAD = 120.0 * Math.PI / 180;
		
		int nums = 3;
		int x[] = new int[nums];
		int y[] = new int[nums];
		
		x[0] = (int)(Math.cos(rad) * LENGTH);
		y[0] = (int)(Math.sin(rad) * LENGTH);
//		Point[] wings = new Point[2];
		int count = 1;
		for(int w = -1; w < 2; w += 2){
			x[count] = (int)(Math.cos(rad + w * WING_RAD) * WING_LENGTH);
			y[count] = (int)(Math.sin(rad + w * WING_RAD) * WING_LENGTH);
			count ++;
		}
		
		for(int j = 0; j < x.length; j ++){
			x[j] += pointX;
			y[j] += pointY;
		}
		g.setColor(col);
		g.fillPolygon(x, y, nums);
	}

	private void drawLines(Graphics g) {
		for(int i = 0; i < levelForDraw.getLinsChunk().getNumEntries(); i ++){
			LinsEntry line = levelForDraw.getLinsChunk().getEntry(i);
			short[] endpoints = line.getEndpoints();
			EpntEntry startPoint = levelForDraw.getEpntChunk().getEntry(endpoints[0]);
			short[] vertex = startPoint.getVertex();
			Point start = getViewPointFromWorldPoint(vertex[0], vertex[1]);

			EpntEntry endPoint = levelForDraw.getEpntChunk().getEntry(endpoints[1]);
			vertex = endPoint.getVertex();
			Point end = getViewPointFromWorldPoint(vertex[0], vertex[1]);
			if(!this.getBounds().contains(start) && !this.getBounds().contains(end)){
				continue;
			}
			g.setColor(Color.black);
			g.drawLine(start.x, start.y, end.x, end.y);
		}
	}

	/**
	 * convert world point2d to view point
	 * @param worldPointX
	 * @param worldPointY	
	 * @return
	 */
	public Point getViewPointFromWorldPoint(short worldPointX, short worldPointY) {
		Point offset = this.scroller.getOffset();
		double zoom = this.scroller.getZoom();
		Point point = new Point();
		point.x = (int)((Math.abs(StaticData.WORLD_MIN) + worldPointX) * zoom - offset.x);
		point.y = (int)((Math.abs(StaticData.WORLD_MIN) + worldPointY) * zoom - offset.y);
		return point;
	}

	/**
	 * draw outter frame
	 * @param g
	 */
	private void drawMainFrame(Graphics g) {
		Point offset = this.scroller.getOffset();
		double zoom = this.scroller.getZoom();
		int left = - offset.x;
		int top = - offset.y;
		int width = (int)((double)(StaticData.WORLD_MAX - StaticData.WORLD_MIN) * zoom);
		int height = width;
		g.drawRect(left, top, width, height);
		
	}
	
	public void setLevel(Level lvl){
		levelForDraw = lvl;
		//set camera
		try{	
			ObjsEntry player = StaticData.getPlayer(levelForDraw);
			cameraPosition[0] = (int)(player.getX() * StaticData.WORLD_ONE);
			cameraPosition[1] = (int)(player.getY() * StaticData.WORLD_ONE);
			cameraPosition[2] = (int)(player.getZ() * StaticData.WORLD_ONE);
			int facing = player.getFacing();
			cameraDirectionRadian = (double)facing / 512.0 * 2 * Math.PI;
		}catch (NoPlayerException e) {
		}		
		repaint();
	}
	
	public void clearLevel(){
		levelForDraw = null;
	}

	public void mouseClicked(MouseEvent arg0) {
	}

	public void mouseEntered(MouseEvent arg0) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void mouseExited(MouseEvent arg0) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void mousePressed(MouseEvent arg0) {
		dragStartPoint = arg0.getPoint();
	}

	public void mouseReleased(MouseEvent arg0) {
//		if(toolbarDialog.getToolType() == ToolbarDialog.TOOL_ZOOM){
//			toolbarDialog.setToolType(ToolbarDialog.TOOL_HAND);
//		}
	}

	public void mouseDragged(MouseEvent arg0) {
		Point newPoint = arg0.getPoint();
		Point offset = this.scroller.getOffset();
		if(isCtrlPressed || toolbarDialog.getToolType() == ToolbarDialog.TOOL_HAND){
			offset.x -= (newPoint.x - dragStartPoint.x);
			offset.y -= (newPoint.y - dragStartPoint.y);
			this.scroller.setOffset(offset);
			repaint();
		}else if(toolbarDialog.getToolType() == ToolbarDialog.TOOL_ZOOM){
			double zoom = this.scroller.getZoom();
			double delta = Scroller.ZOOM_STEP * DRAG_ZOOM_STEP * (newPoint.y - dragStartPoint.y);
			zoom += delta;
			this.scroller.setZoom(zoom, this.getWidth(), this.getHeight());
			repaint();
		}
		dragStartPoint = newPoint;
	}

	public void mouseMoved(MouseEvent arg0) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void keyPressed(KeyEvent arg0) {
//		System.out.println(arg0);
		if(arg0.getKeyCode() == KeyEvent.VK_CONTROL){
			isCtrlPressed = true;
		}
	}

	public void keyReleased(KeyEvent arg0) {
		isCtrlPressed = false;
	}

	public void keyTyped(KeyEvent arg0) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void mouseWheelMoved(MouseWheelEvent arg0) {
		int rotation = arg0.getWheelRotation();
		double zoom = scroller.getZoom();
		double newZoom = zoom + (double)rotation * Scroller.ZOOM_STEP / DRAG_ZOOM_STEP;
		scroller.setZoom(newZoom, this.getWidth(), this.getHeight());
		repaint();
	}

	public int[] getCameraPosition() {
		return cameraPosition;
	}

	public void setCameraPosition(int[] cameraPosition) {
		this.cameraPosition = cameraPosition;
		repaint();
	}

	public double getCameraDirectionRadian() {
		return cameraDirectionRadian;
	}

	public void setCameraDirectionRadian(double cameraDirectionRadian) {
		this.cameraDirectionRadian = cameraDirectionRadian;
	}

	public void setToolbarDialog(ToolbarDialog toolbarDialog) {
		this.toolbarDialog = toolbarDialog;
	}
	

}