/*
	File:		MacGamma.h

	Contains:	Functions to enable Mac OS device gamma adjustments using 3 channel 256 element 8 bit gamma ramps

	Written by:	Geoff Stahl (ggs)

	Copyright:	Copyright  1999 Apple Computer, Inc., All Rights Reserved

	Change History (most recent first):

         <7>     8/25/99    ggs     Added usage notes
         <6>     8/25/99    ggs     Added usage notes
         <5>     7/14/99    ggs     Added sample code notice
         <4>     5/20/99    ggs     Updated function names.
         <3>     5/20/99    ggs     Cleaned up and commented
         <2>     5/20/99    ggs     Added system wide get and restore gamma functions to enable
                                    restoration of original for all devices.  Modified functionality
                                    to return pointers vice squirreling away the memory.
         <1>     5/20/99    ggs     Initial Add

	Disclaimer:	You may incorporate this sample code into your applications without
				restriction, though the sample code has been provided "AS IS" and the
				responsibility for its operation is 100% yours.  However, what you are
				not permitted to do is to redistribute the source as "DSC Sample Code"
				after having made changes. If you're going to re-distribute the source,
				we require that you make it clear in the source that the code was
				descended from Apple Sample Code, but that you've made changes.

*/


// Usage notes: 

// SetDeviceGammaRampXX may not return until the VBL following their call, depending on the display driver,
// this is due to the handling of the Control call by the driver.

// Startup and Shutdown:

// GetSystemGammas (...) must be called to save the system gammas prior to using MacGamma
// RestoreSystemGamms (...)  must be called before exiting to restore original gamma
// DisposeSystemGammas (...) can then be used to dispose of the system gammas

// Suspend and Resume:

// RestoreSystemGamms (...); DisposeSystemGammas (...); should also be called prior to suspend and
// GetSystemGammas (...) should be called when resuming
// this prevents users from saving display settings with your gammas


// include control --------------------------------------------------

#ifndef MacGamma_h
#define MacGamma_h


// includes ---------------------------------------------------------

#include <Quickdraw.h>
#include <QDOffscreen.h>


// public function declarations -------------------------------------

// 5/20/99: (ggs) added system wide gamma get and restore

#ifdef __cplusplus
extern "C" {
#endif

Ptr GetSystemGammas (void);										// returns a pointer to a set of all current device gammas in native format
																	// (returns NULL on failure, which means reseting gamma will not be possible)
void RestoreSystemGammas (Ptr pSystemGammas);					// restores all system devices to saved gamma setting
void DisposeSystemGammas (Ptr* ppSystemGammas);					// iterates through and deletes stored gamma settings


Boolean GetDeviceGammaRampGD (GDHandle hGD, Ptr pRamp);			// retrieves the gamma ramp from a graphics device (pRamp: 3 arrays of 256 elements each)
Boolean GetDeviceGammaRampGW (GWorldPtr pGW, Ptr pRamp);		// retrieves the gamma ramp from a graphics device associated with a GWorld pointer (pRamp: 3 arrays of 256 elements each)
Boolean GetDeviceGammaRampCGP (CGrafPtr pGraf, Ptr pRamp);		// retrieves the gamma ramp from a graphics device associated with a CGraf pointer (pRamp: 3 arrays of 256 elements each)

Boolean SetDeviceGammaRampGD (GDHandle hGD, Ptr pRamp);			// sets the gamma ramp for a graphics device (pRamp: 3 arrays of 256 elements each (R,G,B))
Boolean SetDeviceGammaRampGW (GWorldPtr pGW, Ptr pRamp);		// sets the gamma ramp for a graphics device associated with a GWorld pointer (pRamp: 3 arrays of 256 elements each (R,G,B))
Boolean SetDeviceGammaRampCGP (CGrafPtr pGraf, Ptr pRamp);		// sets the gamma ramp for a graphics device associated with a CGraf pointer (pRamp: 3 arrays of 256 elements each (R,G,B))

#ifdef __cplusplus
}
#endif

#endif // MacGamma_h
