/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import src.backend.SidsEntry;
import src.backend.StaticFunctions;
import src.gui.Model;
import src.gui.SidsFlagsFrame_btnCancel_actionAdapter;
import src.gui.SidsFlagsFrame_btnOK_actionAdapter;

public class SidsFlagsFrame
extends JFrame {
    private final int CP_STATUS = 1;
    private final int IS_CP = 2;
    private final int REPAIR = 4;
    private final int DESTRUCTIVE = 8;
    private final int LIGHT = 16;
    private final int CAN_BE_DESTROYED = 32;
    private final int ONLY_PROJECTILES = 64;
    private Model model;
    private int levelIndex;
    private SidsEntry entry;
    JCheckBox chkIsCP = new JCheckBox();
    JCheckBox chkIsRepair = new JCheckBox();
    JCheckBox chkIsDestructive = new JCheckBox();
    JCheckBox chkIsLightSwitch = new JCheckBox();
    JCheckBox chkCanBeDestroyed = new JCheckBox();
    JCheckBox chkOnlyProjectiles = new JCheckBox();
    JCheckBox chkCPStatus = new JCheckBox();
    JButton btnOK = new JButton();
    JButton btnCancel = new JButton();

    public SidsFlagsFrame(Model model, int levelIndex, SidsEntry entry) {
        try {
            this.model = model;
            this.levelIndex = levelIndex;
            this.entry = entry;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        this.chkIsCP.setText("Is Control Panel");
        this.chkIsCP.setBounds(new Rectangle(9, 28, 164, 19));
        this.chkIsDestructive.setText("Is Destructive Switch");
        this.chkIsDestructive.setBounds(new Rectangle(9, 66, 212, 19));
        this.chkIsLightSwitch.setText("Is Light Switch");
        this.chkIsLightSwitch.setBounds(new Rectangle(9, 85, 176, 19));
        this.chkCanBeDestroyed.setText("Can be destroyed");
        this.chkCanBeDestroyed.setBounds(new Rectangle(9, 104, 187, 19));
        this.chkOnlyProjectiles.setText("Toggled by Projectile");
        this.chkOnlyProjectiles.setBounds(new Rectangle(9, 123, 219, 19));
        this.chkCPStatus.setText("Control Panel Status");
        this.chkCPStatus.setBounds(new Rectangle(9, 9, 158, 19));
        this.btnOK.setBounds(new Rectangle(110, 151, 78, 31));
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new SidsFlagsFrame_btnOK_actionAdapter(this));
        this.btnCancel.setBounds(new Rectangle(26, 151, 78, 31));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new SidsFlagsFrame_btnCancel_actionAdapter(this));
        this.getContentPane().add(this.chkCPStatus);
        this.getContentPane().add(this.chkIsCP);
        this.getContentPane().add(this.chkIsRepair);
        this.getContentPane().add(this.chkIsDestructive);
        this.getContentPane().add(this.chkIsLightSwitch);
        this.getContentPane().add(this.chkCanBeDestroyed);
        this.getContentPane().add(this.chkOnlyProjectiles);
        this.getContentPane().add(this.btnCancel);
        this.getContentPane().add(this.btnOK);
        this.chkIsRepair.setText("Is Repair Switch");
        this.chkIsRepair.setBounds(new Rectangle(9, 47, 207, 19));
        this.loadInfo();
        this.setSize(230, 220);
        this.setTitle("Side Flags");
        StaticFunctions.centerFrame(this);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void loadInfo() {
        short flags = this.entry.getFlags();
        if ((flags & 1) > 0) {
            this.chkCPStatus.setSelected(true);
        }
        if ((flags & 2) > 0) {
            this.chkIsCP.setSelected(true);
        }
        if ((flags & 4) > 0) {
            this.chkIsRepair.setSelected(true);
        }
        if ((flags & 8) > 0) {
            this.chkIsDestructive.setSelected(true);
        }
        if ((flags & 0x10) > 0) {
            this.chkIsLightSwitch.setSelected(true);
        }
        if ((flags & 0x20) > 0) {
            this.chkCanBeDestroyed.setSelected(true);
        }
        if ((flags & 0x40) > 0) {
            this.chkOnlyProjectiles.setSelected(true);
        }
    }

    public void btnCancel_actionPerformed(ActionEvent e) {
        this.model.removeChildFrame(this);
        this.dispose();
    }

    public void btnOK_actionPerformed(ActionEvent e) {
        short flags = 0;
        if (this.chkCPStatus.isSelected()) {
            flags = (short)(flags + 1);
        }
        if (this.chkIsCP.isSelected()) {
            flags = (short)(flags + 2);
        }
        if (this.chkIsRepair.isSelected()) {
            flags = (short)(flags + 4);
        }
        if (this.chkIsDestructive.isSelected()) {
            flags = (short)(flags + 8);
        }
        if (this.chkIsLightSwitch.isSelected()) {
            flags = (short)(flags + 16);
        }
        if (this.chkCanBeDestroyed.isSelected()) {
            flags = (short)(flags + 32);
        }
        if (this.chkOnlyProjectiles.isSelected()) {
            flags = (short)(flags + 64);
        }
        this.entry.setFlags(flags);
        this.model.removeChildFrame(this);
        this.dispose();
    }
}

