/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import javax.swing.table.AbstractTableModel;
import src.backend.PolyEntry;
import src.backend.StaticFunctions;
import src.gui.Model;

public class PolyTableModel
extends AbstractTableModel {
    public static final int POLY_INDEX = 0;
    public static final int POLY_TYPE = 1;
    public static final int POLY_PERM = 2;
    public static final int POLY_FH = 3;
    public static final int POLY_CH = 4;
    public static final int POLY_MEDIA = 5;
    private String[] colNames;
    private PolyEntry[] data;
    private int[] indexNums;
    private Model model;

    public PolyTableModel(String[] colNames, Model model, int levelIndex) {
        this.colNames = colNames;
        this.model = model;
        this.data = new PolyEntry[this.model.getPolyNumber(levelIndex)];
        this.indexNums = new int[this.model.getPolyNumber(levelIndex)];
        int i = 0;
        while (i < this.model.getPolyNumber(levelIndex)) {
            this.indexNums[i] = i;
            this.data[i] = this.model.getPoly(levelIndex, i);
            ++i;
        }
    }

    public String getColumnName(int col) {
        return this.colNames[col];
    }

    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return new Integer(this.indexNums[row]);
            }
            case 1: {
                return this.getTypeString(this.data[row].getType());
            }
            case 2: {
                return new Integer(this.data[row].getPermutation());
            }
        }
        return new Object();
    }

    private String getTypeString(int num) {
        return StaticFunctions.polygonTypeNames[num];
    }

    private Integer getTypeNum(String str) {
        int i = 0;
        while (i < StaticFunctions.polygonTypeNames.length) {
            if (str.equals(StaticFunctions.polygonTypeNames[i])) {
                return new Integer(i);
            }
            ++i;
        }
        return new Integer(-1);
    }

    public void setValueAt(Object value, int row, int column) {
        switch (column) {
            case 1: {
                Integer tempValue = this.getTypeNum((String)value);
                this.data[row].setType(tempValue.shortValue());
                break;
            }
            case 2: {
                Integer tempValue = Integer.valueOf((String)value);
                this.data[row].setPermutation(tempValue.shortValue());
                break;
            }
            default: {
                System.out.println("Invalid PolyTable index");
            }
        }
        this.fireTableCellUpdated(row, column);
    }

    public int getRowCount() {
        return this.data.length;
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public void sort(int header, boolean reverse) {
        switch (header) {
            case 0: {
                this.sortBy(reverse, "index");
                break;
            }
            case 1: {
                this.sortBy(reverse, "type");
                break;
            }
            case 2: {
                this.sortBy(reverse, "perm");
            }
        }
        this.fireTableDataChanged();
    }

    private void sortBy(boolean reverse, String type) {
        this.mergeSort(0, this.indexNums.length, reverse, type);
    }

    private void mergeSort(int first, int n, boolean reverse, String type) {
        if (n > 1) {
            int n1 = n / 2;
            int n2 = n - n1;
            this.mergeSort(first, n1, reverse, type);
            this.mergeSort(first + n1, n2, reverse, type);
            this.merge(first, n1, n2, reverse, type);
        }
    }

    private void merge(int first, int n1, int n2, boolean reverse, String type) {
        int[] temp = new int[n1 + n2];
        PolyEntry[] tempEntry = new PolyEntry[n1 + n2];
        int copied = 0;
        int copied1 = 0;
        int copied2 = 0;
        while (copied1 < n1 && copied2 < n2) {
            if (this.compare(reverse, type, first, copied1, copied2, n1)) {
                temp[copied++] = this.indexNums[first + copied1++];
                tempEntry[copied - 1] = this.data[first + copied1 - 1];
                continue;
            }
            temp[copied++] = this.indexNums[first + n1 + copied2++];
            tempEntry[copied - 1] = this.data[first + n1 + copied2 - 1];
        }
        while (copied1 < n1) {
            temp[copied++] = this.indexNums[first + copied1++];
            tempEntry[copied - 1] = this.data[first + copied1 - 1];
        }
        while (copied2 < n2) {
            temp[copied++] = this.indexNums[first + n1 + copied2++];
            tempEntry[copied - 1] = this.data[first + n1 + copied2 - 1];
        }
        int i = 0;
        while (i < n1 + n2) {
            this.indexNums[first + i] = temp[i];
            this.data[first + i] = tempEntry[i];
            ++i;
        }
    }

    private boolean compare(boolean reverse, String type, int first, int copied1, int copied2, int n1) {
        if (!reverse && type.equals("index")) {
            return this.indexNums[first + copied1] < this.indexNums[first + n1 + copied2];
        }
        if (reverse && type.equals("index")) {
            return this.indexNums[first + copied1] > this.indexNums[first + n1 + copied2];
        }
        if (!reverse && type.equals("type")) {
            return this.data[first + copied1].getType() < this.data[first + n1 + copied2].getType();
        }
        if (reverse && type.equals("type")) {
            return this.data[first + copied1].getType() > this.data[first + n1 + copied2].getType();
        }
        if (!reverse && type.equals("perm")) {
            return this.data[first + copied1].getPermutation() < this.data[first + n1 + copied2].getPermutation();
        }
        if (reverse && type.equals("perm")) {
            return this.data[first + copied1].getPermutation() > this.data[first + n1 + copied2].getPermutation();
        }
        return false;
    }
}

