/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import java.util.StringTokenizer;
import src.backend.GetFile;
import src.backend.Level;
import src.gui.Model;

public class TextureScriptParser {
    public TextureScriptParser(int levelIndex, Model model, String infile, String outfile) {
        this.parse(levelIndex, model, infile, outfile);
    }

    public TextureScriptParser(Level level, String infile) {
        this.parse(level, infile);
    }

    private void parse(Level level, String infile) {
        GetFile file = new GetFile(infile);
        String currentToken = "";
        String partLine = "";
        int line = 0;
        String writeLine = "";
        while (!file.havehitEOF()) {
            StringTokenizer st2;
            StringTokenizer st1;
            ++line;
            int trans1 = -1;
            int trans2 = -1;
            int cp1 = -1;
            int cp2 = -1;
            try {
                st1 = new StringTokenizer(file.getLine(), "-");
                partLine = st1.nextToken();
                if (partLine.substring(0, 1).equals("#")) continue;
                st2 = new StringTokenizer(partLine, ",");
            }
            catch (Exception e) {
                continue;
            }
            try {
                int bit2;
                int col2;
                int col1 = Integer.parseInt(st2.nextToken());
                int bit1 = Integer.parseInt(st2.nextToken());
                if (st2.hasMoreTokens()) {
                    trans1 = Integer.parseInt(st2.nextToken());
                    if (st2.hasMoreTokens()) {
                        cp1 = Integer.parseInt(st2.nextToken());
                        st2 = new StringTokenizer(st1.nextToken(), ",");
                        col2 = Integer.parseInt(st2.nextToken());
                        bit2 = Integer.parseInt(st2.nextToken());
                        trans2 = Integer.parseInt(st2.nextToken());
                        cp2 = Integer.parseInt(st2.nextToken());
                        writeLine = String.valueOf(writeLine) + col2 + "," + bit2 + "," + trans2 + "," + cp2 + "-" + col1 + "," + bit1 + "," + trans1 + cp1 + "\n";
                    } else {
                        st2 = new StringTokenizer(st1.nextToken(), ",");
                        col2 = Integer.parseInt(st2.nextToken());
                        bit2 = Integer.parseInt(st2.nextToken());
                        trans2 = Integer.parseInt(st2.nextToken());
                        writeLine = String.valueOf(writeLine) + col2 + "," + bit2 + "," + trans2 + "-" + col1 + "," + bit1 + "," + trans1 + "\n";
                    }
                } else {
                    st2 = new StringTokenizer(st1.nextToken(), ",");
                    col2 = Integer.parseInt(st2.nextToken());
                    bit2 = Integer.parseInt(st2.nextToken());
                    writeLine = String.valueOf(writeLine) + col2 + "," + bit2 + "-" + col1 + "," + bit1 + "\n";
                }
                if (trans1 == -1) {
                    level.convertLevelTextures(col1, bit1, col2, bit2);
                    continue;
                }
                if (cp1 == -1) {
                    level.convertLevelTextures(col1, bit1, trans1, col2, bit2, trans2);
                    continue;
                }
                level.convertLevelTextures(col1, bit1, trans1, cp1, col2, bit2, trans2, cp2);
            }
            catch (Exception e) {
                System.out.println("Syntax error in script: Line " + line);
            }
        }
        file.close();
    }

    private void parse(int levelIndex, Model model, String infile, String outfile) {
        GetFile file = new GetFile(infile);
        GetFile ofile = new GetFile(outfile);
        ofile = new GetFile(outfile);
        String currentToken = "";
        String partLine = "";
        int line = 0;
        String writeLine = "";
        while (!file.havehitEOF()) {
            StringTokenizer st2;
            StringTokenizer st1;
            ++line;
            int trans1 = -1;
            int trans2 = -1;
            int cp1 = -1;
            int cp2 = -1;
            try {
                st1 = new StringTokenizer(file.getLine(), "-");
                partLine = st1.nextToken();
                if (partLine.substring(0, 1).equals("#")) continue;
                st2 = new StringTokenizer(partLine, ",");
            }
            catch (Exception e) {
                continue;
            }
            try {
                int bit2;
                int col2;
                int col1 = Integer.parseInt(st2.nextToken());
                int bit1 = Integer.parseInt(st2.nextToken());
                if (st2.hasMoreTokens()) {
                    trans1 = Integer.parseInt(st2.nextToken());
                    if (st2.hasMoreTokens()) {
                        cp1 = Integer.parseInt(st2.nextToken());
                        st2 = new StringTokenizer(st1.nextToken(), ",");
                        col2 = Integer.parseInt(st2.nextToken());
                        bit2 = Integer.parseInt(st2.nextToken());
                        trans2 = Integer.parseInt(st2.nextToken());
                        cp2 = Integer.parseInt(st2.nextToken());
                        writeLine = String.valueOf(writeLine) + col2 + "," + bit2 + "," + trans2 + "," + cp2 + "-" + col1 + "," + bit1 + "," + trans1 + cp1 + "\n";
                    } else {
                        st2 = new StringTokenizer(st1.nextToken(), ",");
                        col2 = Integer.parseInt(st2.nextToken());
                        bit2 = Integer.parseInt(st2.nextToken());
                        trans2 = Integer.parseInt(st2.nextToken());
                        writeLine = String.valueOf(writeLine) + col2 + "," + bit2 + "," + trans2 + "-" + col1 + "," + bit1 + "," + trans1 + "\n";
                    }
                } else {
                    st2 = new StringTokenizer(st1.nextToken(), ",");
                    col2 = Integer.parseInt(st2.nextToken());
                    bit2 = Integer.parseInt(st2.nextToken());
                    writeLine = String.valueOf(writeLine) + col2 + "," + bit2 + "-" + col1 + "," + bit1 + "\n";
                }
                if (trans1 == -1) {
                    model.convertTextures(levelIndex, col1, bit1, col2, bit2);
                    continue;
                }
                if (cp1 == -1) {
                    model.convertTextures(levelIndex, col1, bit1, trans1, col2, bit2, trans2);
                    continue;
                }
                model.convertTextures(levelIndex, col1, bit1, trans1, cp1, col2, bit2, trans2, cp2);
            }
            catch (Exception e) {
                System.out.println("Syntax error in script: Line " + line);
            }
        }
        ofile.setLine(writeLine);
        file.close();
        ofile.close();
    }
}

