/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import src.backend.Chunk;
import src.backend.ChunkHeader;
import src.backend.IChunk;
import src.backend.Level;
import src.backend.MapWriter;
import src.backend.PolyEntry;
import src.backend.ShapeDescriptor;
import src.backend.StaticFunctions;

public class PolyChunk
extends Chunk
implements IChunk {
    private PolyEntry[] entries;
    private int numEntries;

    public PolyChunk(Level level, ChunkHeader header) {
        super(level, header);
    }

    public PolyChunk() {
    }

    public PolyEntry getEntry(int entry) {
        if (entry < this.entries.length) {
            return this.entries[entry];
        }
        System.out.println("PolyChunk does not contain that many entries. Returning highest entry.");
        return this.entries[this.entries.length - 1];
    }

    public void read() {
        super.read();
        MapWriter mw = this.level.getMapData().getMapWriter();
        this.numEntries = this.header.getLength() / 128;
        this.entries = new PolyEntry[this.numEntries];
        mw.seek(this.header.getOffset() + 16);
        int i = 0;
        while (i < this.entries.length) {
            PolyEntry polyEntry = new PolyEntry(this);
            this.entries[i] = polyEntry.read();
            ++i;
        }
    }

    public void write() {
        super.write();
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16 + this.getLevel().getOffset());
        int i = 0;
        while (i < this.entries.length) {
            this.entries[i].write();
            ++i;
        }
    }

    public int getNumEntries() {
        return this.entries.length;
    }

    public int getEntryLength() {
        return 128;
    }

    public int calc() {
        return super.calc();
    }

    public void convertTextures() {
        int i = 0;
        while (i < this.entries.length) {
            PolyEntry pe = this.entries[i];
            ShapeDescriptor[] sd = new ShapeDescriptor[]{pe.getFloorTexture(), pe.getCeilingTexture()};
            int j = 0;
            while (j < sd.length) {
                int k = 1;
                while (k < StaticFunctions.TEXTURE_CUTOFFS.length) {
                    if (sd[j].getColl() == 17 && sd[j].getBmp() >= StaticFunctions.TEXTURE_CUTOFFS[k - 1] && sd[j].getBmp() < StaticFunctions.TEXTURE_CUTOFFS[k]) {
                        sd[j].setColl(17 + k);
                        short diff = (short)(sd[j].getBmp() - StaticFunctions.TEXTURE_CUTOFFS[k - 1]);
                        sd[j].setBmp(diff);
                        sd[j].setColl(k);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void convertTextures(short coll1, short bmp1, short coll2, short bmp2) {
        int i = 0;
        while (i < this.entries.length) {
            PolyEntry pe = this.entries[i];
            ShapeDescriptor[] sd = new ShapeDescriptor[]{pe.getFloorTexture(), pe.getCeilingTexture()};
            int j = 0;
            while (j < sd.length) {
                if (sd[j].getColl() == coll1 && sd[j].getBmp() == bmp1) {
                    sd[j].setColl(coll2);
                    sd[j].setBmp(bmp2);
                    if (coll2 >= 27 && coll2 <= 30) {
                        if (j == 0) {
                            pe.setFloorTransferMode((short)9);
                        } else {
                            pe.setCeilingTransferMode((short)9);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void convertTextures(short coll1, short bmp1, short x1, short coll2, short bmp2, short x2) {
        int i = 0;
        while (i < this.entries.length) {
            PolyEntry pe = this.entries[i];
            ShapeDescriptor[] sd = new ShapeDescriptor[]{pe.getFloorTexture(), pe.getCeilingTexture()};
            int j = 0;
            while (j < sd.length) {
                if (sd[j].getColl() == coll1 && sd[j].getBmp() == bmp1) {
                    if (j == 0 && pe.getFloorTransferMode() == x1) {
                        pe.setFloorTransferMode(x2);
                        sd[j].setColl(coll2);
                        sd[j].setBmp(bmp2);
                    }
                    if (j == 1 && pe.getCeilingTransferMode() == x1) {
                        pe.setCeilingTransferMode(x2);
                        sd[j].setColl(coll2);
                        sd[j].setBmp(bmp2);
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

