/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.CRC32;
import src.backend.MacBinaryHeader;
import src.backend.MapData;

public class MapWriter {
    private RandomAccessFile rf;
    String err = "File IO error.";
    private boolean isMacBinary = false;
    private boolean isValidMapFile = false;
    private int extraOffset = 0;
    private String inFileString;
    private MacBinaryHeader macBinaryHeader;
    private byte[] resourceFork;
    private long bytesChecked = 0L;
    private long bytesToCheck = 0L;

    public MapWriter(String inFileString) {
        try {
            this.inFileString = inFileString;
            File inFile = new File(inFileString);
            this.rf = new RandomAccessFile(inFile, "rw");
            this.isMacBinary = this.macBinTest();
            this.isValidMapFile = this.verifyValidMapFile();
        }
        catch (FileNotFoundException fnfEx) {
            System.out.println("File not found.");
        }
        catch (IOException e) {
            System.out.println(this.err);
        }
    }

    public void read(byte[] data) {
        try {
            this.rf.read(data);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public void write(byte[] data) {
        try {
            this.rf.write(data);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public void close() {
        try {
            this.rf.close();
        }
        catch (Exception e) {
            MapWriter.pErr(e);
        }
    }

    public void newRF(String path, MapData md) {
        int len = md.getMapLength() + 128;
        if (this.isMacBinary) {
            MacBinaryHeader mbh = this.macBinaryHeader;
            len += mbh.getDataLength() + mbh.getResourceLength() + 128;
        }
        try {
            this.rf.close();
            this.rf = new RandomAccessFile(path, "rw");
            this.rf.setLength(len);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public void setFileSize(MapData md) {
        int len = md.getMapLength() + 128;
        if (this.isMacBinary) {
            MacBinaryHeader mbh = this.macBinaryHeader;
            len += mbh.getDataLength() + mbh.getResourceLength() + 128;
        }
        try {
            this.rf.setLength(len);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public long getBytesChecked() {
        return this.bytesChecked;
    }

    public void incrementBytesChecked() {
        ++this.bytesChecked;
    }

    public void resetBytesChecked() {
        this.bytesChecked = 0L;
    }

    public void setBytesToCheck(long bytes) {
        this.bytesToCheck = bytes;
    }

    public long getBytesToCheck() {
        return this.bytesToCheck;
    }

    public long generateChecksum(int len, int trailer_len) {
        long cksum = -1L;
        try {
            int map_file_length = len + trailer_len;
            this.setBytesToCheck(map_file_length);
            this.seek(0L);
            byte[] mapData = new byte[map_file_length];
            this.rf.read(mapData);
            CRC32 crc32 = new CRC32();
            crc32.update(mapData);
            cksum = crc32.getValue();
            this.resetBytesChecked();
            this.setBytesToCheck(0L);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
        return cksum;
    }

    public RandomAccessFile getReadFile() {
        return this.rf;
    }

    public boolean getFileLoaded() {
        return this.rf != null;
    }

    public void writeByte(byte b) {
        try {
            this.rf.writeByte(b);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public void writeByte(char c) {
        try {
            this.rf.writeByte(c);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public void writeByte(int i) {
        try {
            this.rf.writeByte(i);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public void writeShort(short s) {
        try {
            this.rf.writeShort(s);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public void writeInt(int i) {
        try {
            this.rf.writeInt(i);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public void writeLong(long l) {
        try {
            this.rf.writeLong(l);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public byte readByte() {
        byte b = -1;
        try {
            b = this.rf.readByte();
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
        return b;
    }

    public short readShort() {
        short s = -1;
        try {
            s = this.rf.readShort();
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
        return s;
    }

    public int readUnsignedShort() {
        int s = -1;
        try {
            s = this.rf.readUnsignedShort();
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
        return s;
    }

    public int readInt() {
        int i = -1;
        try {
            i = this.rf.readInt();
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
        return i;
    }

    public long readLong() {
        long l = -1L;
        try {
            l = this.rf.readLong();
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
        return l;
    }

    public void skipBytes(int i) {
        try {
            this.rf.skipBytes(i);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public void seek(long l) {
        try {
            this.rf.seek(l + (long)this.extraOffset);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public long getFilePointer() {
        long point = -1L;
        try {
            point = this.rf.getFilePointer() - (long)this.extraOffset;
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
        return point;
    }

    public long length() {
        long len = -1L;
        try {
            len = this.rf.length();
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
        return len;
    }

    public void setLength(long length) {
        try {
            this.rf.setLength(length);
        }
        catch (IOException e) {
            MapWriter.pErr(e);
        }
    }

    public void adjust(int len) {
        this.setLength(this.length() + (long)len);
        if (this.isMacBinary) {
            MacBinaryHeader header = this.macBinaryHeader;
            header.setDataLength(header.getDataLength() + len);
        }
    }

    public static void pErr(Exception e) {
        System.out.println("IOException in MapWriter");
        e.printStackTrace();
    }

    private boolean macBinTest() {
        boolean result = false;
        this.seek(65L);
        byte a = this.readByte();
        byte b = this.readByte();
        byte c = this.readByte();
        System.out.println(String.valueOf(a) + " " + b + " " + c);
        if (a == 115 && b == 99 && c == 101) {
            result = true;
            this.extraOffset = 128;
            System.out.println("MacBinary Detected.");
            this.macBinaryHeader = new MacBinaryHeader(this);
            this.resourceFork = new byte[this.macBinaryHeader.getResourceLength()];
            int resOffset = this.macBinaryHeader.getDataLength() + 127;
            this.seek(resOffset &= 0xFFFFFF80);
            this.read(this.resourceFork);
        }
        return result;
    }

    private boolean verifyValidMapFile() {
        this.seek(0L);
        short firstShort = this.readShort();
        short secondShort = this.readShort();
        if (firstShort != 2 && firstShort != 4 || secondShort != 1 && secondShort != 2) {
            System.out.println("The file specified is not a valid map file");
            return false;
        }
        return true;
    }

    public MacBinaryHeader getMacBinaryHeader() {
        return this.macBinaryHeader;
    }

    public boolean isMacBinary() {
        return this.isMacBinary;
    }

    public boolean isValidMapFile() {
        return this.isValidMapFile;
    }

    public void writeMacBinary() {
        if (this.isMacBinary) {
            this.macBinaryHeader.write();
            this.seek(this.macBinaryHeader.getDataLength());
            int mod = this.macBinaryHeader.getDataLength() % 128;
            int pad = 0;
            if (mod != 0) {
                pad = 128 - mod;
                byte[] padding = new byte[pad];
                this.write(padding);
            }
            System.out.println("seeking to end of data: " + this.macBinaryHeader.getDataLength());
            this.write(this.resourceFork);
        }
    }

    public void zeroMap() {
        int fileLength = (int)this.length();
        byte[] zero = new byte[fileLength];
        this.seek(0 - this.extraOffset);
        this.write(zero);
    }
}

