/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import src.backend.CRC16;
import src.backend.MapWriter;

public class MacBinaryHeader {
    private static final int HEADER_LEN = 128;
    byte version = 0;
    byte fileNameLength;
    byte[] filename = new byte[63];
    int fileType;
    int fileCreator;
    byte finderFlags;
    byte fill1 = 0;
    short vertical;
    short horizontal;
    short windowID;
    byte protect;
    byte fill2 = 0;
    int dataLength;
    int resourceLength;
    int creationDate;
    int modifiedDate;
    short infoCommentLength;
    byte moreFinderFlags;
    int signature;
    byte script;
    byte extendedFinderFlags;
    byte[] unused1 = new byte[8];
    int totalFileLength;
    short secondaryHeaderLength;
    byte macBin3Version;
    byte minimumMacBinaryVersion;
    short prevCRC;
    MapWriter mw;

    public MacBinaryHeader(MapWriter mw) {
        this.mw = mw;
        this.mw.seek(-128L);
        this.version = this.mw.readByte();
        this.fileNameLength = this.mw.readByte();
        int i = 0;
        while (i < 63) {
            this.filename[i] = this.mw.readByte();
            ++i;
        }
        this.fileType = this.mw.readInt();
        this.fileCreator = this.mw.readInt();
        this.finderFlags = this.mw.readByte();
        this.fill1 = this.mw.readByte();
        this.vertical = this.mw.readShort();
        this.horizontal = this.mw.readShort();
        this.windowID = this.mw.readShort();
        this.protect = this.mw.readByte();
        this.fill2 = this.mw.readByte();
        this.dataLength = this.mw.readInt();
        this.resourceLength = this.mw.readInt();
        this.creationDate = this.mw.readInt();
        this.modifiedDate = this.mw.readInt();
        this.infoCommentLength = this.mw.readShort();
        this.moreFinderFlags = this.mw.readByte();
        this.signature = this.mw.readInt();
        this.script = this.mw.readByte();
        this.extendedFinderFlags = this.mw.readByte();
        i = 0;
        while (i < 8) {
            this.unused1[i] = this.mw.readByte();
            ++i;
        }
        this.totalFileLength = this.mw.readInt();
        this.secondaryHeaderLength = this.mw.readShort();
        this.macBin3Version = this.mw.readByte();
        this.minimumMacBinaryVersion = this.mw.readByte();
        this.prevCRC = this.mw.readShort();
    }

    public void write() {
        this.mw.seek(-128L);
        this.mw.writeByte(this.version);
        this.mw.writeByte(this.fileNameLength);
        int i = 0;
        while (i < 63) {
            this.mw.writeByte(this.filename[i]);
            ++i;
        }
        this.mw.writeInt(this.fileType);
        this.mw.writeInt(this.fileCreator);
        this.mw.writeByte(this.finderFlags);
        this.mw.writeByte(this.fill1);
        this.mw.writeShort(this.vertical);
        this.mw.writeShort(this.horizontal);
        this.mw.writeShort(this.windowID);
        this.mw.writeByte(this.protect);
        this.mw.writeByte(this.fill2);
        this.mw.writeInt(this.dataLength);
        this.mw.writeInt(this.resourceLength);
        this.mw.writeInt(this.creationDate);
        this.mw.writeInt(this.modifiedDate);
        this.mw.writeShort(this.infoCommentLength);
        this.mw.writeByte(this.moreFinderFlags);
        this.mw.writeInt(this.signature);
        this.mw.writeByte(this.script);
        this.mw.writeByte(this.extendedFinderFlags);
        i = 0;
        while (i < 8) {
            this.mw.writeByte(this.unused1[i]);
            ++i;
        }
        this.mw.writeInt(this.totalFileLength);
        this.mw.writeShort(this.secondaryHeaderLength);
        this.mw.writeByte(this.macBin3Version);
        this.mw.writeByte(this.minimumMacBinaryVersion);
        this.mw.writeShort((short)0);
        this.mw.seek(-128L);
        byte[] header124 = new byte[124];
        this.mw.read(header124);
        CRC16 crc16 = new CRC16();
        crc16.update(header124);
        System.out.println("Old Macbin CRC: " + this.prevCRC);
        this.prevCRC = crc16.getValue();
        System.out.println("New Macbin CRC: " + this.prevCRC);
        this.mw.seek(-4L);
        this.mw.writeShort(this.prevCRC);
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int len) {
        this.dataLength = len;
    }

    public int getResourceLength() {
        return this.resourceLength;
    }

    public void setResourceLength(int len) {
        this.resourceLength = len;
    }
}

