/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import src.backend.ChunkHeader;
import src.backend.Level;

public abstract class Chunk {
    protected Level level;
    protected ChunkHeader header;
    protected boolean hasChanged = false;

    public Chunk(Level level, ChunkHeader header) {
        this.level = level;
        this.header = header;
        this.header.setChunk(this);
    }

    public Chunk() {
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setHeader(ChunkHeader header) {
        this.header = header;
    }

    public Level getLevel() {
        return this.level;
    }

    public ChunkHeader getHeader() {
        return this.header;
    }

    public int getTag() {
        return this.header.getTag();
    }

    public int getNextOffset() {
        return this.header.getNextOffset();
    }

    public int getLength() {
        return this.header.getLength();
    }

    public int getOffset() {
        return this.header.getOffset();
    }

    public void write() {
        System.out.print(".");
        this.header.write();
    }

    public void read() {
    }

    public abstract int getEntryLength();

    public abstract int getNumEntries();

    public int calc() {
        return this.getEntryLength() * this.getNumEntries();
    }
}

