/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import src.backend.PlacEntry;
import src.backend.Preferences;
import src.backend.StaticFunctions;
import src.gui.Model;
import src.gui.PlacTableModel;

public class PlacFrame
extends JFrame {
    private String[] columnNames = new String[]{"Item", "Initial", "Minimum", "Maximum", "Random Location", "Random Number Available", "Infinite Available", "Random Appearance Percent"};
    public static final int ITEMS = 0;
    public static final int MONSTERS = 1;
    private Model model;
    private int levelIndex;
    private int type;
    private JTable table;
    private JScrollPane scroller;
    private PlacTableModel tableModel;
    private PlacEntry[] redoTable;
    private int clickCount;
    JMenuBar mnuBar = new JMenuBar();
    JMenu mnuCommands = new JMenu();
    JMenuItem mnuCommandsUndo = new JMenuItem();
    JMenuItem mnuCommandsClearKeepInitial = new JMenuItem();
    JMenuItem mnuCommandsClearAll = new JMenuItem();
    JMenuItem mnuCommandsAutoFill = new JMenuItem();
    JMenuItem mnuCommandsZeroRow = new JMenuItem();

    public PlacFrame(Model model, int levelIndex, int type) {
        this.model = model;
        this.levelIndex = levelIndex;
        this.type = type;
        if (type == 0) {
            this.columnNames[0] = "Items";
            this.setTitle("Item Parameters - " + model.getLevelSelectName());
        } else {
            this.columnNames[0] = "Monsters";
            this.setTitle("Monster Parameters - " + model.getLevelSelectName());
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.tableModel = this.type == 0 ? new PlacTableModel(this.columnNames, this.model, this.levelIndex, 36, 0, 36) : new PlacTableModel(this.columnNames, this.model, this.levelIndex, 47, 36, 83);
        this.tableModel.addTableModelListener(new PlacTableModelListener());
        this.table = new JTable(this.tableModel);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        TableColumn randomCol = this.table.getColumnModel().getColumn(4);
        TableColumn infAvailCol = this.table.getColumnModel().getColumn(6);
        JCheckBox chkRandom = new JCheckBox();
        JCheckBox chkInfAvail = new JCheckBox();
        randomCol.setCellEditor(new DefaultCellEditor(chkRandom));
        infAvailCol.setCellEditor(new DefaultCellEditor(chkInfAvail));
        randomCol.setCellRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JCheckBox box = new JCheckBox();
                box.setBackground(Color.white);
                try {
                    if (((Boolean)value).booleanValue()) {
                        box.setSelected(true);
                        return box;
                    }
                    box.setSelected(false);
                    return box;
                }
                catch (Exception exception) {
                    return new JCheckBox();
                }
            }
        });
        infAvailCol.setCellRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JCheckBox box = new JCheckBox();
                box.setBackground(Color.white);
                try {
                    if (((Boolean)value).booleanValue()) {
                        box.setSelected(true);
                        return box;
                    }
                    box.setSelected(false);
                    return box;
                }
                catch (Exception exception) {
                    return new JCheckBox();
                }
            }
        });
        this.scroller = new JScrollPane(this.table);
        this.table.getTableHeader().addMouseListener(new MouseListener(){

            public void mouseExited(MouseEvent m) {
            }

            public void mouseEntered(MouseEvent m) {
            }

            public void mouseReleased(MouseEvent m) {
            }

            public void mousePressed(MouseEvent m) {
            }

            public void mouseClicked(MouseEvent m) {
                Point mousePoint = new Point(m.getX(), m.getY());
                int header = PlacFrame.this.table.getTableHeader().columnAtPoint(mousePoint);
                PlacFrame placFrame = PlacFrame.this;
                placFrame.clickCount = placFrame.clickCount + 1;
                boolean reverseOrder = false;
                if (PlacFrame.this.clickCount % 2 == 0) {
                    reverseOrder = true;
                }
                PlacFrame.this.tableModel.sort(header, reverseOrder);
            }
        });
        this.getContentPane().add(this.scroller);
        this.addWindowListener(new WindowListener(){

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                PlacFrame.this.closeTable();
            }

            public void windowOpened(WindowEvent e) {
            }
        });
        this.clickCount = 0;
        this.setJMenuBar(this.mnuBar);
        this.mnuCommands.setText("Commands");
        this.mnuCommandsUndo.setText("Undo since last command");
        this.mnuCommandsUndo.addActionListener(new PlacFrame_mnuCommandsUndo_actionAdapter(this));
        this.mnuCommandsClearKeepInitial.setText("Clear (keep initial)");
        this.mnuCommandsClearKeepInitial.addActionListener(new PlacFrame_mnuCommandsClearKeepInitial_actionAdapter(this));
        this.mnuCommandsClearAll.setText("Clear all");
        this.mnuCommandsClearAll.addActionListener(new PlacFrame_mnuCommandsClearAll_actionAdapter(this));
        this.mnuCommandsAutoFill.setText("Auto fill");
        this.mnuCommandsAutoFill.addActionListener(new PlacFrame_mnuCommandsAutoFill_actionAdapter(this));
        this.mnuCommandsZeroRow.setText("Zero Row");
        this.mnuCommandsZeroRow.addActionListener(new PlacFrame_mnuCommandsZeroRow_actionAdapter(this));
        this.mnuBar.add(this.mnuCommands);
        this.mnuCommands.add(this.mnuCommandsUndo);
        this.mnuCommands.add(this.mnuCommandsClearKeepInitial);
        this.mnuCommands.add(this.mnuCommandsClearAll);
        this.mnuCommands.add(this.mnuCommandsZeroRow);
        this.mnuCommands.add(this.mnuCommandsAutoFill);
        this.redoTable = new PlacEntry[this.tableModel.getData().length];
        int i = 0;
        while (i < this.redoTable.length) {
            this.redoTable[i] = new PlacEntry(this.model.getPlacChunk(this.levelIndex));
            ++i;
        }
        this.fillRedoTable();
        this.setSize(600, 500);
        StaticFunctions.centerFrame(this);
        this.setVisible(true);
    }

    private void closeTable() {
        this.model.removeChildFrame(this);
    }

    private void fillRedoTable() {
        try {
            PlacEntry[] data = this.tableModel.getData();
            int i = 0;
            while (i < data.length) {
                this.redoTable[i].setFlags(data[i].getFlags());
                this.redoTable[i].setInitial(data[i].getInitial());
                this.redoTable[i].setMaximum(data[i].getMaximum());
                this.redoTable[i].setMinimum(data[i].getMinimum());
                this.redoTable[i].setRandomChance(data[i].getRandomChance());
                this.redoTable[i].setRandomChancePercent(data[i].getRandomChancePercent());
                this.redoTable[i].setRandomCount(data[i].getRandomCount());
                ++i;
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void mnuCommandsUndo_actionPerformed(ActionEvent e) {
        try {
            PlacEntry[] data = this.tableModel.getData();
            int i = 0;
            while (i < data.length) {
                data[i].setFlags(this.redoTable[i].getFlags());
                data[i].setInitial(this.redoTable[i].getInitial());
                data[i].setMaximum(this.redoTable[i].getMaximum());
                data[i].setMinimum(this.redoTable[i].getMinimum());
                data[i].setRandomChance(this.redoTable[i].getRandomChance());
                data[i].setRandomChancePercent(this.redoTable[i].getRandomChancePercent());
                data[i].setRandomCount(this.redoTable[i].getRandomCount());
                ++i;
            }
            this.tableModel.fireTableDataChanged();
        }
        catch (Exception ex) {
            return;
        }
    }

    public void mnuCommandsClearKeepInitial_actionPerformed(ActionEvent e) {
        try {
            this.fillRedoTable();
            PlacEntry[] data = this.tableModel.getData();
            int i = 0;
            while (i < data.length) {
                data[i].setMaximum((short)0);
                data[i].setMinimum((short)0);
                data[i].setFlags((short)0);
                data[i].setRandomChancePercent(0);
                data[i].setRandomCount(0);
                ++i;
            }
            this.tableModel.fireTableDataChanged();
        }
        catch (Exception ex) {
            return;
        }
    }

    public void mnuCommandsClearAll_actionPerformed(ActionEvent e) {
        try {
            this.fillRedoTable();
            PlacEntry[] data = this.tableModel.getData();
            int i = 0;
            while (i < data.length) {
                data[i].setInitial((short)0);
                data[i].setMaximum((short)0);
                data[i].setMinimum((short)0);
                data[i].setFlags((short)0);
                data[i].setRandomChancePercent(0);
                data[i].setRandomCount(0);
                ++i;
            }
            this.tableModel.fireTableDataChanged();
        }
        catch (Exception ex) {
            return;
        }
    }

    public void mnuCommandsAutoFill_actionPerformed(ActionEvent e) {
        try {
            this.fillRedoTable();
            PlacEntry[] data = this.tableModel.getData();
            short initVal = 0;
            int appear = 0;
            double max = 0.0;
            double min = 0.0;
            int i = 0;
            while (i < data.length) {
                initVal = data[i].getInitial();
                max = (double)initVal * Preferences.MAX_MULT;
                min = (double)initVal * Preferences.MIN_MULT;
                appear = Preferences.APPEAR_PERCENT;
                if (max > 32767.0) {
                    max = 32767.0;
                }
                if (max < 0.0) {
                    max = 0.0;
                }
                if (min > 32767.0) {
                    min = 32767.0;
                }
                if (min < 0.0) {
                    min = 0.0;
                }
                if (appear > 100) {
                    appear = 100;
                }
                if (appear < 0) {
                    appear = 0;
                }
                data[i].setMaximum((short)max);
                data[i].setMinimum((short)min);
                if (data[i].getInitial() > 0) {
                    data[i].setRandomChancePercent(appear);
                }
                ++i;
            }
            this.tableModel.fireTableDataChanged();
        }
        catch (Exception ex) {
            return;
        }
    }

    public void mnuCommandsZeroRow_actionPerformed(ActionEvent e) {
        try {
            this.fillRedoTable();
            int row = this.table.getSelectedRow();
            this.tableModel.getData()[row].setFlags((short)0);
            this.tableModel.getData()[row].setInitial((short)0);
            this.tableModel.getData()[row].setMinimum((short)0);
            this.tableModel.getData()[row].setMaximum((short)0);
            this.tableModel.getData()[row].setRandomChancePercent(0);
            this.tableModel.getData()[row].setRandomCount(0);
            this.tableModel.fireTableRowsUpdated(row, row);
        }
        catch (Exception ex) {
            return;
        }
    }

    class PlacFrame_mnuCommandsUndo_actionAdapter
    implements ActionListener {
        private PlacFrame adaptee;

        PlacFrame_mnuCommandsUndo_actionAdapter(PlacFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsUndo_actionPerformed(e);
        }
    }

    class PlacFrame_mnuCommandsClearKeepInitial_actionAdapter
    implements ActionListener {
        private PlacFrame adaptee;

        PlacFrame_mnuCommandsClearKeepInitial_actionAdapter(PlacFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsClearKeepInitial_actionPerformed(e);
        }
    }

    class PlacFrame_mnuCommandsClearAll_actionAdapter
    implements ActionListener {
        private PlacFrame adaptee;

        PlacFrame_mnuCommandsClearAll_actionAdapter(PlacFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsClearAll_actionPerformed(e);
        }
    }

    class PlacFrame_mnuCommandsAutoFill_actionAdapter
    implements ActionListener {
        private PlacFrame adaptee;

        PlacFrame_mnuCommandsAutoFill_actionAdapter(PlacFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsAutoFill_actionPerformed(e);
        }
    }

    class PlacFrame_mnuCommandsZeroRow_actionAdapter
    implements ActionListener {
        private PlacFrame adaptee;

        PlacFrame_mnuCommandsZeroRow_actionAdapter(PlacFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsZeroRow_actionPerformed(e);
        }
    }

    class PlacTableModelListener
    implements TableModelListener {
        PlacTableModelListener() {
        }

        public void tableChanged(TableModelEvent evt) {
            if (evt.getType() == 0) {
                int column = evt.getColumn();
                int row = evt.getFirstRow();
                PlacFrame.this.table.setRowSelectionInterval(row, row);
            }
        }
    }
}

