/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import src.backend.Entry;
import src.backend.MapWriter;
import src.backend.PlacChunk;

public class PlacEntry
extends Entry {
    private short flags;
    private short initial;
    private short minimum;
    private short maximum;
    private int random_count;
    private int random_chance;
    private static final int MAX_CHANCE = 65500;

    public PlacEntry(PlacChunk chunk) {
        super(chunk);
    }

    public void setFlags(short flags) {
        this.flags = flags;
        this.change();
    }

    public void setInitial(short initial) {
        this.initial = initial;
        this.change();
    }

    public void setMinimum(short minimum) {
        this.minimum = minimum;
        this.change();
    }

    public void setMaximum(short maximum) {
        this.maximum = maximum;
        this.change();
    }

    public void setRandomCount(int count) {
        this.random_count = count;
        this.change();
    }

    public void setRandomChance(int chance) {
        this.random_chance = chance;
        this.change();
    }

    public short getFlags() {
        return this.flags;
    }

    public short getInitial() {
        return this.initial;
    }

    public short getMinimum() {
        return this.minimum;
    }

    public short getMaximum() {
        return this.maximum;
    }

    public int getRandomCount() {
        return this.random_count;
    }

    public int getRandomChance() {
        return this.random_chance;
    }

    public int getRandomChancePercent() {
        int percent = 100 * this.random_chance / 65500;
        return percent;
    }

    public void setRandomChancePercent(int percent) {
        int chance;
        this.random_chance = chance = percent * 65500 / 100;
        this.change();
    }

    public void write() {
        super.write();
        MapWriter mw = this.getChunk().getLevel().getMapData().getMapWriter();
        mw.writeShort(this.flags);
        mw.writeShort(this.initial);
        mw.writeShort(this.minimum);
        mw.writeShort(this.maximum);
        mw.writeShort((short)this.random_count);
        mw.writeShort((short)this.random_chance);
    }
}

