/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import java.util.ArrayList;
import src.backend.Chunk;
import src.backend.ChunkHeader;
import src.backend.Level;
import src.backend.MapWriter;
import src.backend.ObjsEntry;
import src.backend.PolyEntry;

public class ObjsChunk
extends Chunk {
    private ArrayList entries = new ArrayList(0);
    private int numEntries;

    public ObjsChunk(Level level, ChunkHeader header) {
        super(level, header);
    }

    public ObjsChunk() {
    }

    public ObjsEntry getEntry(int entry) {
        if (entry < this.entries.size()) {
            return (ObjsEntry)this.entries.get(entry);
        }
        System.out.println("ObjsChunk does not contain that many entries. Returning highest entry.");
        return (ObjsEntry)this.entries.get(this.entries.size() - 1);
    }

    public void read() {
        super.read();
        MapWriter mw = this.level.getMapData().getMapWriter();
        this.numEntries = this.header.getLength() / 16;
        mw.seek(this.header.getOffset() + 16);
        int i = 0;
        while (i < this.numEntries) {
            ObjsEntry objsEntry = new ObjsEntry(this);
            objsEntry.read();
            this.entries.add(objsEntry);
            ++i;
        }
    }

    public void write() {
        super.write();
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16);
        int i = 0;
        while (i < this.entries.size()) {
            ((ObjsEntry)this.entries.get(i)).write();
            ++i;
        }
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public int getEntryLength() {
        return 16;
    }

    public ObjsEntry addEntry() {
        ObjsEntry o = new ObjsEntry(this);
        o.setType((short)1);
        o.setSubtype((short)0);
        o.setFacing((short)0);
        o.setPolygon((short)0);
        PolyEntry p = this.level.getPolyChunk().getEntry(0);
        double x = p.getX();
        double y = p.getY();
        double z = 0.0;
        o.setX(x);
        o.setY(y);
        o.setZ(z);
        o.setFlags((short)0);
        this.entries.add(o);
        int len = 16;
        this.header.autoAdjust(len);
        ++this.numEntries;
        o.changePlacData(1);
        return o;
    }

    public void addEntry(ObjsEntry oe) {
        int len = 16;
        this.entries.add(oe);
        this.header.autoAdjust(len);
        oe.changePlacData(1);
        ++this.numEntries;
    }

    public ObjsEntry removeEntry(ObjsEntry o) {
        int i = 0;
        while (i < this.entries.size()) {
            if (o.equals(this.getEntry(i))) {
                this.entries.remove(i);
                int len = -16;
                this.header.autoAdjust(len);
                --this.numEntries;
                o.changePlacData(-1);
                return o;
            }
            ++i;
        }
        System.out.println("That ObjsEntry does not exist in the ObjsChunk and can't be removed.");
        return o;
    }
}

