/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import src.backend.Chunk;
import src.backend.MapWriter;

public class ChunkHeader {
    Chunk chunk;
    String tagString;
    int tag;
    int nextOffset;
    int offset;
    int length;
    private boolean hasChanged = false;

    public void setChunk(Chunk chunk) {
        this.chunk = chunk;
        this.change();
    }

    public void setTag(int tag) {
        this.tag = tag;
        this.change();
    }

    public void setTagString(String tag) {
        this.tagString = tag;
    }

    public void setNextOffset(int nextOffset) {
        this.nextOffset = nextOffset;
        this.change();
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void autoAdjust(int diff) {
        System.out.println("Old length: " + this.getLength());
        this.adjust(diff);
        this.chunk.getLevel().getMapData().autoAdjust(diff, this.getOffset());
    }

    public void adjust(int len) {
        this.setLength(this.getLength() + len);
        System.out.println("New length: " + this.getLength());
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.change();
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public int getTag() {
        return this.tag;
    }

    public String getTagString() {
        return this.tagString;
    }

    public int getNextOffset() {
        return this.nextOffset;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void change() {
        this.hasChanged = true;
        if (this.chunk != null) {
            this.chunk.change();
        }
    }

    public void resetChange() {
        this.hasChanged = false;
    }

    public void write() {
        MapWriter mw = this.chunk.getLevel().getMapData().getMapWriter();
        mw.seek(this.offset);
        mw.writeInt(this.tag);
        mw.writeInt(this.nextOffset);
        mw.writeInt(this.length);
        mw.writeInt(0);
    }
}

