/*
 * Decompiled with CFR 0.152.
 */
package jp.hpl.gui.render;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import jp.hpl.gui.IMapViewerFrame;
import jp.hpl.gui.render.Camera;
import jp.hpl.gui.render.LineRenderer;
import jp.hpl.gui.render.Transformer;
import src.backend.Level;

public class RenderCanvas
extends JPanel
implements MouseInputListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private Level levelForDraw;
    private Transformer transformer;
    private static final double MOUSE_DRAG_TURN_SPEED = 0.1;
    private static final double KEYBORD_SPEED_ROTATE = 3.0;
    private static final double KEYBORD_SPEED = 5.0;
    public static final double RATE = 0.061037018951994385;
    double RANGE = 100.0;
    Point previousPoint = new Point();
    LineRenderer lineRenderer;
    IMapViewerFrame parent;

    public RenderCanvas(IMapViewerFrame parent, Level l) {
        this.setDoubleBuffered(true);
        this.levelForDraw = l;
        this.transformer = new Transformer();
        this.parent = parent;
        double[] playerPosition3D = new double[]{0.0, 50.0, -150.0};
        double phi = 0.0;
        int[] c = parent.getCanvas().getCameraPosition();
        playerPosition3D[0] = (double)c[0] * 0.061037018951994385;
        playerPosition3D[2] = (double)c[1] * 0.061037018951994385;
        playerPosition3D[1] = (double)c[2] * 0.061037018951994385;
        this.transformer.getCamera().setCenter(playerPosition3D);
        this.transformer.getCamera().setTheta(-0.0);
        this.transformer.getCamera().setPhi(phi);
        this.transformer.doCalcTransformArray();
        this.lineRenderer = new LineRenderer(this.transformer, this.levelForDraw, this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setEnabled(true);
        this.setFocusable(true);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setupSize();
        this.lineRenderer.draw(this, g);
        Camera camera = this.transformer.getCamera();
        double[] cameraPosition3D = camera.getCenter();
        g.drawString("Center:" + cameraPosition3D[0] + "," + cameraPosition3D[1] + "," + cameraPosition3D[2], 0, 20);
        g.drawString("Theta:" + camera.getTheta() * 180.0 / Math.PI + " Phi:" + camera.getPhi() * 180.0 / Math.PI, 0, 30);
    }

    public void setupSize() {
        int width = this.getWidth();
        int height = this.getHeight();
        this.transformer.setViewSize(width, height, -this.RANGE, this.RANGE, -this.RANGE, this.RANGE);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.previousPoint = e.getPoint();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        Camera camera = this.transformer.getCamera();
        double theta = camera.getTheta() + Math.PI / 180 * (double)(p.y - this.previousPoint.y) * 0.1;
        double phi = camera.getPhi() + Math.PI / 180 * (double)(p.x - this.previousPoint.x) * 0.1;
        camera.setTheta(theta);
        camera.setPhi(phi);
        this.transformer.doCalcTransformArray();
        this.repaint();
        this.previousPoint = p;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyPressed(KeyEvent arg0) {
        Camera camera = this.transformer.getCamera();
        double[] center = camera.getCenter();
        double phi = camera.getPhi();
        boolean isRepaint = false;
        if (arg0.getKeyCode() == 38) {
            center[0] = center[0] + Math.sin(-phi) * 5.0;
            center[2] = center[2] + Math.cos(-phi) * 5.0;
            camera.setCenter(center);
            isRepaint = true;
        } else if (arg0.getKeyCode() == 40) {
            center[0] = center[0] - Math.sin(-phi) * 5.0;
            center[2] = center[2] - Math.cos(-phi) * 5.0;
            camera.setCenter(center);
            isRepaint = true;
        } else if (arg0.getKeyCode() == 37) {
            camera.setPhi(phi += 0.05235987755982989);
            isRepaint = true;
        } else if (arg0.getKeyCode() == 39) {
            camera.setPhi(phi -= 0.05235987755982989);
            isRepaint = true;
        } else if (arg0.getKeyCode() == 65) {
            center[1] = center[1] + 5.0;
            camera.setCenter(center);
            isRepaint = true;
        } else if (arg0.getKeyCode() == 90) {
            center[1] = center[1] - 5.0;
            camera.setCenter(center);
            isRepaint = true;
        }
        if (isRepaint) {
            this.transformer.doCalcTransformArray();
            double[] center1 = camera.getCenter();
            int[] c = new int[]{(int)(center1[0] / 0.061037018951994385), (int)(center1[2] / 0.061037018951994385), (int)(center1[1] / 0.061037018951994385)};
            this.parent.getCanvas().setCameraPosition(c);
            this.parent.getCanvas().setCameraDirectionRadian(phi);
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

