/*
 * Decompiled with CFR 0.152.
 */
package jp.hpl.gui.preferences;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import src.backend.GetFile;

public class Preferences {
    public Map dataMap = new HashMap();
    private static Preferences instance = new Preferences();
    public static final String MAP_DEFAULT_PATH = "MapDefaultPath";
    public static final String ENDPOINT_COLOR = "EndpointColor";
    public static final String WALL_LINE_COLOR = "WallLineColor";
    public static final String STAIR_LINE_COLOR = "StairLineColor";
    public static final String FLOOR_LINE_COLOR = "FloorColor";
    private static final String PREFERENCE_FILE_NAME = "Preferences.ini";
    private static final String SEPARATOR = "=";

    private Preferences() {
        this.setDefault();
    }

    public static Preferences getInstance() {
        return instance;
    }

    public void loadFromFile() {
        GetFile file = new GetFile(PREFERENCE_FILE_NAME);
        String currentToken = "";
        while (!file.havehitEOF()) {
            StringTokenizer tokenizer = new StringTokenizer(file.getLine());
            try {
                currentToken = tokenizer.nextToken();
            }
            catch (Exception e) {
                continue;
            }
            try {
                if (!currentToken.equals(MAP_DEFAULT_PATH)) continue;
                this.dataMap.put(MAP_DEFAULT_PATH, tokenizer.nextToken());
            }
            catch (Exception e) {
                this.dataMap.put(MAP_DEFAULT_PATH, "");
            }
        }
        file.close();
    }

    public void setDefault() {
        this.dataMap.put(MAP_DEFAULT_PATH, "");
    }

    public String get(String key) {
        return (String)this.dataMap.get(key);
    }

    public void set(String key, String value) {
        this.dataMap.put(key, value);
    }

    public void storeToFile() {
        GetFile file = new GetFile(PREFERENCE_FILE_NAME);
        file.clearFile();
        Iterator it = this.dataMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String line = String.valueOf(key) + SEPARATOR + (String)this.dataMap.get(key);
            file.setLine(String.valueOf(line) + "\n");
        }
        file.close();
    }
}

