/*
 * Decompiled with CFR 0.152.
 */
package jp.hpl.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import jp.hpl.data.EpntEntry;
import jp.hpl.data.StaticData;
import jp.hpl.exception.NoPlayerException;
import jp.hpl.gui.Scroller;
import src.backend.Level;
import src.backend.LinsEntry;
import src.backend.ObjsEntry;
import src.backend.PolyEntry;

public class MapCanvas
extends JPanel
implements MouseInputListener,
KeyListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    private Scroller scroller;
    private static int MENUBAR_HEIGHT = 20;
    private static int FONT_HEIGHT = 12;
    private Level levelForDraw = null;
    private Point dragStartPoint;
    private boolean isCtrlPressed = false;
    Map mapIconList = new HashMap();
    private JFrame parent;
    private static String MAP_ICON_IMAGE_LIST_FILE_PATH = "resources/MapIconImageList.txt";
    private static String MAP_ICONS_DIR_PATH = "resources/Map Icons/";
    private static String MAP_ICONS_HIGHLIGHTED_DIR_PATH = String.valueOf(MAP_ICONS_DIR_PATH) + "Highlighted/";
    private static String MAP_ICONS_CAMERA_POSITION_IMAGE_FILE_NAME = "center X.png";
    private Image mapIconCemraPositionImage;
    int[] cameraPosition = new int[3];
    double cameraDirectionRadian = 0.0;

    public MapCanvas(JFrame p) {
        this.setDoubleBuffered(true);
        this.setBackground(Color.white);
        this.scroller = new Scroller();
        this.dragStartPoint = new Point();
        this.parent = p;
        try {
            String path;
            BufferedReader br = new BufferedReader(new FileReader(MAP_ICON_IMAGE_LIST_FILE_PATH));
            String line = "";
            int type = 0;
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                path = String.valueOf(MAP_ICONS_DIR_PATH) + line;
                StaticData.logln(path);
                Image img = Toolkit.getDefaultToolkit().getImage(path);
                this.mapIconList.put(type, img);
                ++type;
            }
            br.close();
            path = String.valueOf(MAP_ICONS_DIR_PATH) + MAP_ICONS_CAMERA_POSITION_IMAGE_FILE_NAME;
            this.mapIconCemraPositionImage = Toolkit.getDefaultToolkit().getImage(path);
        }
        catch (FileNotFoundException e) {
            System.err.println("cannot find map icon image list");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("cannot load map icon image list");
            e.printStackTrace();
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setEnabled(true);
        this.setFocusable(true);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawMainFrame(g);
        if (this.levelForDraw != null) {
            this.drawPolygons(g);
            this.drawLines(g);
            this.drawEndpoints(g);
            this.drawObjects(g);
            Point p = this.getViewPointFromWorldPoint((short)this.cameraPosition[0], (short)this.cameraPosition[1]);
            this.drawTriangle(-this.cameraDirectionRadian + 1.5707963267948966, p.x, p.y, Color.blue, g);
            g.drawImage(this.mapIconCemraPositionImage, p.x, p.y, this);
            g.setColor(Color.black);
            g.drawString(this.levelForDraw.getlevelSelectName(), 0, MENUBAR_HEIGHT);
        }
        Point offset = this.scroller.getOffset();
        g.drawString("Offset:" + offset.x + "," + offset.y, 0, MENUBAR_HEIGHT + FONT_HEIGHT);
        g.drawString("Zoom:" + this.scroller.getZoom(), 0, MENUBAR_HEIGHT + FONT_HEIGHT * 2);
        g.drawString("Camera:" + this.cameraPosition[0] + "," + this.cameraPosition[1] + "," + this.cameraPosition[2], 0, MENUBAR_HEIGHT + FONT_HEIGHT * 3);
    }

    private void drawEndpoints(Graphics g) {
        int i = 0;
        while (i < this.levelForDraw.getEpntChunk().getNumEntries()) {
            EpntEntry endpoint = this.levelForDraw.getEpntChunk().getEntry(i);
            short[] vertex = endpoint.getVertex();
            Point point = this.getViewPointFromWorldPoint(vertex[0], vertex[1]);
            if (this.getBounds().contains(point)) {
                g.setColor(Color.blue);
                g.fillRect(point.x - 1, point.y - 1, 2, 2);
            }
            ++i;
        }
    }

    private void drawPolygons(Graphics g) {
        int i = 0;
        while (i < this.levelForDraw.getPolyChunk().getNumEntries()) {
            PolyEntry poly = this.levelForDraw.getPolyChunk().getEntry(i);
            short[] endpoints = poly.getEndpoint_indexes();
            int vertexCount = poly.getVertex_count();
            int[] x = new int[vertexCount];
            int[] y = new int[vertexCount];
            boolean isInRegion = false;
            int endpointEntryIndex = 0;
            while (endpointEntryIndex < vertexCount) {
                EpntEntry endpoint = this.levelForDraw.getEpntChunk().getEntry(endpoints[endpointEntryIndex]);
                short[] vertex = endpoint.getVertex();
                Point vp = this.getViewPointFromWorldPoint(vertex[0], vertex[1]);
                if (this.getBounds().contains(vp)) {
                    isInRegion = true;
                }
                x[endpointEntryIndex] = vp.x;
                y[endpointEntryIndex] = vp.y;
                ++endpointEntryIndex;
            }
            if (isInRegion) {
                g.setColor(Color.gray);
                g.fillPolygon(x, y, vertexCount);
            }
            ++i;
        }
    }

    private void drawObjects(Graphics g) {
        int i = 0;
        while (i < this.levelForDraw.getObjsChunk().getNumEntries()) {
            ObjsEntry obj = this.levelForDraw.getObjsChunk().getEntry(i);
            short worldX = (short)(obj.getX() * 1024.0);
            short worldY = (short)(obj.getY() * 1024.0);
            short subtype = obj.getSubtype();
            short type = obj.getType();
            Point v = this.getViewPointFromWorldPoint(worldX, worldY);
            if (this.getBounds().contains(v)) {
                switch (type) {
                    case 0: 
                    case 3: {
                        short facing = obj.getFacing();
                        double rad = (double)facing / 512.0 * 2.0 * Math.PI;
                        Color col = Color.red;
                        if (type == 3) {
                            col = Color.yellow;
                        }
                        this.drawTriangle(rad, v.x, v.y, col, g);
                        break;
                    }
                    case 2: {
                        g.drawImage((Image)this.mapIconList.get(subtype), v.x, v.y, this);
                        break;
                    }
                    case 4: {
                        g.drawImage((Image)this.mapIconList.get(37), v.x, v.y, this);
                        break;
                    }
                    case 1: {
                        g.drawImage((Image)this.mapIconList.get(38), v.x, v.y, this);
                        break;
                    }
                    case 5: {
                        g.drawImage((Image)this.mapIconList.get(39), v.x, v.y, this);
                    }
                }
            }
            ++i;
        }
    }

    private void drawTriangle(double rad, int pointX, int pointY, Color col, Graphics g) {
        int LENGTH = 10;
        int WING_LENGTH = 5;
        double WING_RAD = 2.0943951023931953;
        int nums = 3;
        int[] x = new int[nums];
        int[] y = new int[nums];
        x[0] = (int)(Math.cos(rad) * 10.0);
        y[0] = (int)(Math.sin(rad) * 10.0);
        int count = 1;
        int w = -1;
        while (w < 2) {
            x[count] = (int)(Math.cos(rad + (double)w * 2.0943951023931953) * 5.0);
            y[count] = (int)(Math.sin(rad + (double)w * 2.0943951023931953) * 5.0);
            ++count;
            w += 2;
        }
        int j = 0;
        while (j < x.length) {
            int n = j;
            x[n] = x[n] + pointX;
            int n2 = j++;
            y[n2] = y[n2] + pointY;
        }
        g.setColor(col);
        g.fillPolygon(x, y, nums);
    }

    private void drawLines(Graphics g) {
        int i = 0;
        while (i < this.levelForDraw.getLinsChunk().getNumEntries()) {
            LinsEntry line = this.levelForDraw.getLinsChunk().getEntry(i);
            short[] endpoints = line.getEndpoints();
            EpntEntry startPoint = this.levelForDraw.getEpntChunk().getEntry(endpoints[0]);
            short[] vertex = startPoint.getVertex();
            Point start = this.getViewPointFromWorldPoint(vertex[0], vertex[1]);
            EpntEntry endPoint = this.levelForDraw.getEpntChunk().getEntry(endpoints[1]);
            vertex = endPoint.getVertex();
            Point end = this.getViewPointFromWorldPoint(vertex[0], vertex[1]);
            if (this.getBounds().contains(start) || this.getBounds().contains(end)) {
                g.setColor(Color.black);
                g.drawLine(start.x, start.y, end.x, end.y);
            }
            ++i;
        }
    }

    public Point getViewPointFromWorldPoint(short worldPointX, short worldPointY) {
        Point offset = this.scroller.getOffset();
        double zoom = this.scroller.getZoom();
        Point point = new Point();
        point.x = (int)((double)(Math.abs(Short.MIN_VALUE) + worldPointX) * zoom - (double)offset.x);
        point.y = (int)((double)(Math.abs(Short.MIN_VALUE) + worldPointY) * zoom - (double)offset.y);
        return point;
    }

    private void drawMainFrame(Graphics g) {
        int width;
        Point offset = this.scroller.getOffset();
        double zoom = this.scroller.getZoom();
        int left = -offset.x;
        int top = -offset.y;
        int height = width = (int)(65535.0 * zoom);
        g.drawRect(left, top, width, height);
    }

    public void setLevel(Level lvl) {
        this.levelForDraw = lvl;
        try {
            ObjsEntry player = StaticData.getPlayer(this.levelForDraw);
            this.cameraPosition[0] = (int)(player.getX() * 1024.0);
            this.cameraPosition[1] = (int)(player.getY() * 1024.0);
            this.cameraPosition[2] = (int)(player.getZ() * 1024.0);
            short facing = player.getFacing();
            this.cameraDirectionRadian = (double)facing / 512.0 * 2.0 * Math.PI;
        }
        catch (NoPlayerException noPlayerException) {
            // empty catch block
        }
        this.repaint();
    }

    public void clearLevel() {
        this.levelForDraw = null;
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
        this.dragStartPoint = arg0.getPoint();
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void mouseDragged(MouseEvent arg0) {
        if (this.isCtrlPressed) {
            Point newPoint = arg0.getPoint();
            Point offset = this.scroller.getOffset();
            offset.x -= newPoint.x - this.dragStartPoint.x;
            offset.y -= newPoint.y - this.dragStartPoint.y;
            this.scroller.setOffset(offset);
            this.dragStartPoint = newPoint;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent arg0) {
    }

    public void keyPressed(KeyEvent arg0) {
        if (arg0.getKeyCode() == 17) {
            this.isCtrlPressed = true;
        }
    }

    public void keyReleased(KeyEvent arg0) {
        this.isCtrlPressed = false;
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void mouseWheelMoved(MouseWheelEvent arg0) {
        int rotation = arg0.getWheelRotation();
        double zoom = this.scroller.getZoom();
        double newZoom = zoom + (double)rotation * 0.001;
        this.scroller.setZoom(newZoom, this.getWidth(), this.getHeight());
        this.repaint();
    }

    public int[] getCameraPosition() {
        return this.cameraPosition;
    }

    public void setCameraPosition(int[] cameraPosition) {
        this.cameraPosition = cameraPosition;
        this.repaint();
    }

    public double getCameraDirectionRadian() {
        return this.cameraDirectionRadian;
    }

    public void setCameraDirectionRadian(double cameraDirectionRadian) {
        this.cameraDirectionRadian = cameraDirectionRadian;
    }
}

