/*
 * Decompiled with CFR 0.152.
 */
package jp.hpl.data;

import src.backend.Chunk;
import src.backend.Entry;
import src.backend.MapWriter;
import src.backend.WrkArrayReader;

public class EpntEntry
extends Entry {
    public static final int ENTRY_LENGTH = 16;
    private static final int VERTEX_DIMENSION = 2;
    private short flags;
    private short highest_adjacent_floor_height;
    private short lowest_adjacent_ceiling_height;
    private short[] vertex;
    private short[] transformed;
    private short supporting_polygon_index;

    public EpntEntry(Chunk chunk) {
        super(chunk);
    }

    public EpntEntry read() {
        MapWriter mw = this.chunk.getLevel().getMapData().getMapWriter();
        byte[] data = new byte[16];
        mw.read(data);
        WrkArrayReader wrk = new WrkArrayReader(data);
        this.flags = wrk.readShort();
        this.highest_adjacent_floor_height = wrk.readShort();
        this.lowest_adjacent_ceiling_height = wrk.readShort();
        this.vertex = new short[2];
        this.transformed = new short[2];
        int i = 0;
        while (i < 2) {
            this.vertex[i] = wrk.readShort();
            ++i;
        }
        i = 0;
        while (i < 2) {
            this.transformed[i] = wrk.readShort();
            ++i;
        }
        this.supporting_polygon_index = wrk.readShort();
        return this;
    }

    public void write() {
        MapWriter mw = this.chunk.getLevel().getMapData().getMapWriter();
        byte[] data = new byte[16];
        WrkArrayReader wrk = new WrkArrayReader(data);
        wrk.writeShort(this.flags);
        wrk.writeShort(this.highest_adjacent_floor_height);
        wrk.writeShort(this.lowest_adjacent_ceiling_height);
        int i = 0;
        while (i < 2) {
            wrk.writeShort(this.vertex[i]);
            ++i;
        }
        i = 0;
        while (i < 2) {
            wrk.writeShort(this.transformed[i]);
            ++i;
        }
        wrk.writeShort(this.supporting_polygon_index);
        mw.write(data);
    }

    public short getHighest_adjacent_floor_height() {
        return this.highest_adjacent_floor_height;
    }

    public void setHighest_adjacent_floor_height(short highest_adjacent_floor_height) {
        this.highest_adjacent_floor_height = highest_adjacent_floor_height;
    }

    public short getLowest_adjacent_ceiling_height() {
        return this.lowest_adjacent_ceiling_height;
    }

    public void setLowest_adjacent_ceiling_height(short lowest_adjacent_ceiling_height) {
        this.lowest_adjacent_ceiling_height = lowest_adjacent_ceiling_height;
    }

    public short getSupporting_polygon_index() {
        return this.supporting_polygon_index;
    }

    public void setSupporting_polygon_index(short supporting_polygon_index) {
        this.supporting_polygon_index = supporting_polygon_index;
    }

    public short[] getTransformed() {
        short[] newTransformed = new short[2];
        int i = 0;
        while (i < 2) {
            newTransformed[i] = this.transformed[i];
            ++i;
        }
        return newTransformed;
    }

    public void setTransformed(short[] transformed) {
        int i = 0;
        while (i < 2) {
            this.transformed[i] = transformed[i];
            ++i;
        }
    }

    public short[] getVertex() {
        short[] newVertex = new short[2];
        int i = 0;
        while (i < 2) {
            newVertex[i] = this.vertex[i];
            ++i;
        }
        return newVertex;
    }

    public void setVertex(short[] vertex) {
        int i = 0;
        while (i < 2) {
            this.vertex[i] = vertex[i];
            ++i;
        }
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }
}

