/*
 * Decompiled with CFR 0.152.
 */
package jp.hpl.data;

import java.util.ArrayList;
import jp.hpl.data.EpntEntry;
import jp.hpl.data.IChunk;
import src.backend.Chunk;
import src.backend.ChunkHeader;
import src.backend.Level;
import src.backend.MapWriter;

public class EpntChunk
extends Chunk
implements IChunk {
    private ArrayList entries = new ArrayList(0);
    private int numEntries;

    public EpntChunk(Level leve, ChunkHeader header) {
        super(leve, header);
    }

    public EpntChunk() {
    }

    public void read() {
        super.read();
        MapWriter mw = this.level.getMapData().getMapWriter();
        this.numEntries = this.header.getLength() / 16;
        mw.seek(this.header.getOffset() + 16);
        int i = 0;
        while (i < this.numEntries) {
            EpntEntry entry = new EpntEntry(this);
            entry.read();
            this.entries.add(entry);
            ++i;
        }
    }

    public void write() {
        super.write();
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16);
        int i = 0;
        while (i < this.entries.size()) {
            ((EpntEntry)this.entries.get(i)).write();
            ++i;
        }
    }

    public EpntEntry getEntry(int entry) {
        if (entry < this.entries.size()) {
            return (EpntEntry)this.entries.get(entry);
        }
        System.out.println("ObjsChunk does not contain that many entries. Returning highest entry.");
        return (EpntEntry)this.entries.get(this.entries.size() - 1);
    }

    public int getEntryLength() {
        return 16;
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public EpntEntry addEntry() {
        EpntEntry e = new EpntEntry(this);
        int len = this.getEntryLength();
        this.header.autoAdjust(len);
        ++this.numEntries;
        return e;
    }

    public void addEntry(EpntEntry e) {
        int len = this.getEntryLength();
        this.entries.add(e);
        this.header.autoAdjust(len);
        ++this.numEntries;
    }

    public EpntEntry removeEntry(EpntEntry e) {
        if (this.entries.contains(e)) {
            this.entries.remove(e);
            int len = -1 * this.getEntryLength();
            this.header.autoAdjust(len);
            --this.numEntries;
            return e;
        }
        System.out.println("That EpntEntry does not exist in the EpntChunk and can't be removed.");
        return e;
    }
}

