#ifndef TASK_NTL_H
#define TASK_NTL_H

#include "ntl.h"

#define TSKPRI_NTL  5       /**< NTLタスクのプライオリティ。 */
#define TSKSTK_NTL  2048    /**< NTLタスクのスタックサイズ。 */

typedef struct {
    T_MSG header;
    ntl_evtsrc_t evtsrc;
    ntl_evtdesc_t evtdesc;
} ntl_msg_t;

void task_ntl(intptr_t exinf);

void tskapi_ntl_log(ntl_evtsrc_t evtsrc, ntl_evtdesc_t evtdesc);
#define TSKAPI_NTL_LOG(EVTSRC, EVTDESC) \
    tskapi_ntl_log(EVTSRC, EVTDESC)

#endif

