/**
 * @file task_init.c
 * @author Shinichiro Nakamura
 * @brief イニットタスクの実装。
 */

/*
 * ===============================================================
 *  LPCXpresso Clock
 * ===============================================================
 * Copyright (c) 2010-2011 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include <kernel.h>
#include <t_syslog.h>
#include <t_stdlib.h>
#include "kernel_cfg.h"
#include "task_init.h"

/**
 * @brief イニットタスクの実装。
 */
void task_init(intptr_t exinf)
{
    syslog(LOG_NOTICE, "Init task initialized.");

    while(1) {
        act_tsk(TASK_NTL);
        tslp_tsk(500);

        act_tsk(TASK_DISPLAY);
        tslp_tsk(500);

        act_tsk(TASK_GPS);
        tslp_tsk(500);

        act_tsk(TASK_CAMERA);
        tslp_tsk(500);

        act_tsk(TASK_SENSOR);
        tslp_tsk(500);

        act_tsk(TASK_LED);
        tslp_tsk(500);

        act_tsk(TASK_NTSHELL);
        tslp_tsk(500);

        ext_tsk();
    }

    syslog(LOG_NOTICE, "Init task terminated.");
    ext_ker();
    assert(0);
}

