/**
 * ======================================================================
 * NMEA parser (Version 0.0.1)
 * Reference documents:
 * ======================================================================
 * Copyright (c) 2010 Shinichiro Nakamura (CuBeatSystems)
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * ======================================================================
 */

#ifndef NMEA_H
#define NMEA_H

/**
 * @brief NMEAセンテンスのパースを実行する。
 * @details この関数はnmea_getcかnmea_cbfuncが負値を返すまで処理を返さない。
 *
 * @param nmea_getc NMEA受信関数。
 *                  この関数が負値を返すと、その値をこの関数が返す。
 * @param nmea_cbfunc １センテンス受信した時に呼ばれるコールバック関数。
 *                    この関数が負値を返すと、その値をこの関数が返す。
 *
 * @return nmea_getcあるいは、nmea_cbfuncが返した値。
 */
int nmea_parse(
        int (*nmea_getc)(void),
        int (*nmea_cbfunc)(int argc, char **argv, void *extobj),
        void *extobj);

#endif

