/**
 * @file task_ledblink.c
 * @author Shinichiro Nakamura
 * @brief LED Blinkタスクの実装。
 */

/*
 * ===============================================================
 *  LED Blink Task
 * ===============================================================
 * Copyright (c) 2010-2011 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include <kernel.h>
#include <target_syssvc.h>
#include <syssvc/serial.h>
#include "task_ledblink.h"

#define LED_BIT     (1 << 22)
#define LED_FIODIR  (LPC_GPIO0->FIODIR)
#define LED_FIOPIN  (LPC_GPIO0->FIOPIN)
#define LED_INTVAL  (250)

/**
 * @brief LED Blink Taskの本体。
 * @param exinf オプション。
 */
void task_ledblink(intptr_t exinf)
{
    LED_FIODIR |= LED_BIT;

    while (1) {
        LED_FIOPIN ^= LED_BIT;
        tslp_tsk(LED_INTVAL);
    }
}

