#include "defines.h"
#include "kozos.h"
#include "interrupt.h"
#include "lib.h"

/* ƥࡦȥ桼εư */
static int start_threads(int argc, char *argv[])
{
  kz_run(driver_console,    "dConsole",      1, 0x200, 0, NULL);
  kz_run(driver_timer,      "dTimer",        2, 0x200, 0, NULL);
  kz_run(driver_led,        "dLed",          3, 0x200, 0, NULL);
  kz_run(driver_lcd,        "dLcd",          4, 0x200, 0, NULL);
  kz_run(driver_audio,      "dAudio",        5, 0x200, 0, NULL);
  kz_run(task_command,      "tCommand",      6, 0x200, 0, NULL);
  kz_run(task_userinput,    "tUserinput",    7, 0x200, 0, NULL);
  kz_run(task_ir,           "tIr",           8, 0x200, 0, NULL);

  kz_chpri(15); /* ̤ͥ򲼤ơɥ륹åɤ˰ܹԤ */
  INTR_ENABLE; /* ͭˤ */
  while (1) {
    asm volatile ("sleep"); /* ϥ⡼ɤ˰ܹ */
  }

  return 0;
}

int main(void)
{
  INTR_DISABLE; /* ̵ˤ */

  puts("kozos boot succeed!\n");

  /* OSư */
  kz_start(start_threads, "idle", 0, 0x100, 0, NULL);
  /* ˤäƤʤ */

  return 0;
}
