#include "driver_audio.h"
#include "vs1011e.h"
#include "kozos.h"

#define AUDIODRV_CMD_PULSE  'p'

void audio_pulse(void)
{
  char *p;
  p = kz_kmalloc(1);
  p[0] = AUDIODRV_CMD_PULSE;
  kz_send(MSGBOX_ID_AUDIODRIVE, 1, p);
}

static int audiodrv_command(char *p)
{
  int cmd = p[0];
  volatile int i;
  switch (cmd) {
  case AUDIODRV_CMD_PULSE:
    vs1011e_sinetest_init();
    for (i = 0; i < 2000; i++) { }
    vs1011e_sinetest_fini();
    break;
  default:
    break;
  }
  kz_kmfree(p);

  return 0;
}

int driver_audio(int argc, char *argv[])
{
  int size;
  char *p;

  vs1011e_init();

  while (1) {
    kz_recv(MSGBOX_ID_AUDIODRIVE, &size, &p);
    audiodrv_command(p);
  }

  return 0;
}
