#include "task_ir.h"
#include "defines.h"
#include "kozos.h"
#include "intr.h"
#include "led.h"
#include "lib.h"
#include "driver_console.h"
#include "driver_audio.h"
#include "driver_led.h"

#define H8_3069F_ISCR       ((volatile uint8 *)0xFEE014)
#define H8_3069F_IER        ((volatile uint8 *)0xFEE015)
#define H8_3069F_ISR        ((volatile uint8 *)0xFEE016)

#define H8_3069F_TSTR       ((volatile uint8 *)0xFFFF60)
#define H8_3069F_TISRC      ((volatile uint8 *)0xFFFF66)
#define H8_3069F_16TCR0     ((volatile uint8 *)0xFFFF68)
#define H8_3069F_TIOR0      ((volatile uint8 *)0xFFFF69)
#define H8_3069F_16TCNT0H   ((volatile uint8 *)0xFFFF6A)
#define H8_3069F_16TCNT0L   ((volatile uint8 *)0xFFFF6B)

#define MAX_BIT_COUNT (64)

typedef enum {
  WaitLeader,
  FoundLeader,
  Receiving,
  Received
} ir_state_t;

static uint16 bitcnt = 0;
static uint16 tmrovf = 0;
static uint8 data[MAX_BIT_COUNT / 8];
static ir_state_t irs = WaitLeader;

static void remocon_intr_edge(void)
{
  switch (irs) {
    case WaitLeader:
      *H8_3069F_16TCNT0H = 0;
      *H8_3069F_16TCNT0L = 0;
      *H8_3069F_TSTR |= (1 << 0);
      bitcnt = 0;
      tmrovf = 0;
      irs = FoundLeader;
      break;
    case FoundLeader:
      *H8_3069F_16TCNT0H = 0;
      *H8_3069F_16TCNT0L = 0;
      irs = Receiving;
      break;
    case Receiving:
      if (bitcnt < MAX_BIT_COUNT) {
        if ((bitcnt % 8) == 0) {
          data[bitcnt / 8] = 0;
        }
        uint16 tmrval =
          ((*H8_3069F_16TCNT0H) << 8) |
          ((*H8_3069F_16TCNT0L) << 0);
        if (tmrval > 0x1077) {
          data[bitcnt / 8] |= (1 << (bitcnt % 8));
        }
        bitcnt++;
      }
      *H8_3069F_16TCNT0H = 0;
      *H8_3069F_16TCNT0L = 0;
      if (32 <= bitcnt) {
        irs = Received;
      }
      break;
    case Received:
      break;
    default:
      break;
  }

}

static void remocon_intr_tovf(void)
{
  *H8_3069F_TISRC &= ~(1 << 0);
  tmrovf = 1;
  *H8_3069F_TSTR &= ~(1 << 0);
}

int task_ir(int argc, char *argv[])
{
  kz_setintr(SOFTVEC_TYPE_IR_EDGE, remocon_intr_edge);
  kz_setintr(SOFTVEC_TYPE_IR_TOVF, remocon_intr_tovf);
  *H8_3069F_ISCR |= (1 << 4);
  *H8_3069F_IER |= (1 << 4);

  *H8_3069F_TISRC |= (1 << 4);
  *H8_3069F_16TCR0 = 0x03;

  while (1) {
    if (tmrovf) {
      if (bitcnt == 32) {
#if 0
        int i;
        for (i = 0; i < bitcnt; i++) {
          if (data[i / 8] & (1 << (i % 8))) {
            console_write("1");
          } else {
            console_write("0");
          }
        }
        console_write("\n");
#endif
        audio_pulse();
        leddrv_toggle(2);
      }
      bitcnt = 0;
      tmrovf = 0;
      irs = WaitLeader;
    }
  }

  return 0;
}

