#include "defines.h"
#include "interrupt.h"
#include "serial.h"
#include "xmodem.h"
#include "elf.h"
#include "dram.h"
#include "lib.h"
#include "led.h"
#include "re.h"
#include "sw.h"
#include "lcd.h"
#include "pff.h"
#include "vs1011e.h"

static int init(void)
{
  /* ʲϥ󥫡ץȤƤ륷ܥ */
  extern int erodata, data_start, edata, bss_start, ebss;

  /*
   * ǡΰBSSΰ롥νʹߤǤʤȡ
   * ХѿƤʤΤա
   */
  memcpy(&data_start, &erodata, (long)&edata - (long)&data_start);
  memset(&bss_start, 0, (long)&ebss - (long)&bss_start);

  /* եȥߥ٥ */
  softvec_init();

  /* ꥢν */
  serial_init(SERIAL_DEFAULT_DEVICE);

  /* DRAMν */
  dram_init();

  /* LEDν */
  led_init();

  /* ꡼󥳡ν */
  re_init();

  /* åν */
  sw_init();

  /* LCDν */
  lcd_init();

  /* splash */
  lcd_clear();
  lcd_draw_box(0, 0, 121, 31, 0);
  lcd_draw_string(2, 2, "KOZOS EXPBRD #00", 0);

  /* VS1011e */
  vs1011e_init();

  volatile int i;
  vs1011e_sinetest_init();
  for (i = 0; i < 20000; i++) { }
  vs1011e_sinetest_fini();
  for (i = 0; i < 20000; i++) { }
  vs1011e_sinetest_init();
  for (i = 0; i < 20000; i++) { }
  vs1011e_sinetest_fini();
  for (i = 0; i < 20000; i++) { }
  vs1011e_sinetest_init();
  for (i = 0; i < 20000; i++) { }
  vs1011e_sinetest_fini();

  return 0;
}

void boot_from_sdc(const char *filename)
{
  static unsigned char *loadbuf = NULL;
  char *entry_point;
  void (*f)(void);
  extern int buffer_start; /* 󥫡ץȤƤХåե */

  FATFS fatfs;
  WORD br, i;
  BYTE buff[64];
  int rc;

  /*
   * SDɤޥȡ
   */
  rc = pf_mount(&fatfs);
  if (rc) {
    return;
  }

  /*
   * ե򳫤
   */
  rc = pf_open(filename);
  if (rc) {
    return;
  }

  lcd_draw_string(2, 10, "Booting from SDC.", 0);

  /*
   * SDɾOS᡼ɤ߹ߡ
   */
  loadbuf = (char *)(&buffer_start);
  for (;;) {
    rc = pf_read(buff, sizeof(buff), &br);
    if (rc || !br) {
      break;
    }
    for (i = 0; i < br; i++) {
      *loadbuf = buff[i];
      loadbuf++;
    }
    lcd_draw_progressbar(5, 20, 121 - 5, 25, 0, 100, fatfs.fptr * 100 / fatfs.fsize, 0);
    led_toggle(Led1);
    led_toggle(Led2);
  }
  if (rc) {
    lcd_draw_string(2, 10, "File read error.", 0);
    return;
  }

  /*
   * Ÿ()
   */
  loadbuf = (char *)(&buffer_start);
  entry_point = elf_load(loadbuf);

  /*
   * ¹ԡ
   */
  if (!entry_point) {
    lcd_draw_string(2, 10, "Run error.", 0);
  } else {
    lcd_clear();
    led_write(Led1, LedOff);
    led_write(Led2, LedOff);
    led_write(LedG, LedOff);
    led_write(LedR, LedOff);
    f = (void (*)(void))entry_point;
    f();
  }
}

static void wait()
{
  volatile long i;
  for (i = 0; i < 300000; i++)
    ;
}

/* 16ʥ׽ */
static int dump(char *buf, long size)
{
  long i;

  if (size < 0) {
    puts("no data.\n");
    return -1;
  }
  for (i = 0; i < size; i++) {
    putxval(buf[i], 2);
    if ((i & 0xf) == 15) {
      puts("\n");
    } else {
      if ((i & 0xf) == 7) puts(" ");
      puts(" ");
    }
  }
  puts("\n");

  return 0;
}

void boot_from_ser(void)
{
  static char buf[16];
  static long size = -1;
  static unsigned char *loadbuf = NULL;
  char *entry_point;
  void (*f)(void);
  extern int buffer_start; /* 󥫡ץȤƤХåե */

  lcd_draw_string(2, 10, "Waiting a boot image.", 0);

  while (1) {
    puts("kzload> "); /* ץץɽ */
    gets(buf); /* ꥢ뤫Υޥɼ */

    if (!strcmp(buf, "load")) { /* XMODEMǤΥեΥ */
      lcd_draw_string(2, 10, "Receiving a boot image.", 0);
      loadbuf = (char *)(&buffer_start);
      size = xmodem_recv(loadbuf);
      wait(); /* žץ꤬λüץ椬ޤԤ碌 */
      if (size < 0) {
        puts("\nXMODEM receive error!\n");
        lcd_draw_string(2, 10, "Receive error occurred.", 0);
      } else {
        puts("\nXMODEM receive succeeded.\n");
        lcd_draw_string(2, 10, "Receive succeeded.     ", 0);
      }
    } else if (!strcmp(buf, "dump")) { /* 16ʥ׽ */
      puts("size: ");
      putxval(size, 0);
      puts("\n");
      dump(loadbuf, size);
    } else if (!strcmp(buf, "run")) { /* ELFեμ¹ */
      entry_point = elf_load(loadbuf); /* Ÿ() */
      if (!entry_point) {
        puts("run error!\n");
      } else {
        puts("starting from entry point: ");
        putxval((unsigned long)entry_point, 0);
        puts("\n");
        f = (void (*)(void))entry_point;
        f(); /* ǡɤץ˽Ϥ */
        /* ˤ֤äƤʤ */
      }
    }
  }
}

int main(void)
{
  INTR_DISABLE; /* ̵ˤ */

  init();

  boot_from_sdc("kozos");
  boot_from_ser();

  for (;;) { }

  return 0;
}

