#include "defines.h"
#include "interrupt.h"
#include "serial.h"
#include "xmodem.h"
#include "elf.h"
#include "dram.h"
#include "lib.h"
#include "led.h"
#include "re.h"
#include "sw.h"
#include "lcd.h"
#include "pff.h"

static int init(void)
{
  /* ʲϥ󥫡ץȤƤ륷ܥ */
  extern int erodata, data_start, edata, bss_start, ebss;

  /*
   * ǡΰBSSΰ롥νʹߤǤʤȡ
   * ХѿƤʤΤա
   */
  memcpy(&data_start, &erodata, (long)&edata - (long)&data_start);
  memset(&bss_start, 0, (long)&ebss - (long)&bss_start);

  /* եȥߥ٥ */
  softvec_init();

  /* ꥢν */
  serial_init(SERIAL_DEFAULT_DEVICE);

  /* DRAMν */
  dram_init();

  /* LEDν */
  led_init();

  /* ꡼󥳡ν */
  re_init();

  /* åν */
  sw_init();

  /* LCDν */
  lcd_init();

  return 0;
}

void die(int code)
{
  puts("die with code 0x");
  putxval(code, 4);
  puts(".\n");
  while (1) { }
}

int main(void)
{
  static unsigned char *loadbuf = NULL;
  char *entry_point;
  void (*f)(void);
  extern int buffer_start; /* 󥫡ץȤƤХåե */

  INTR_DISABLE; /* ̵ˤ */

  init();


  FATFS fatfs;
  WORD br, i;
  BYTE buff[64];
  int rc;

  lcd_clear();
  lcd_draw_box(0, 0, 121, 31, 0);
  lcd_draw_string(2, 2, "KOZOS EXPBRD #00", 0);
  lcd_draw_string(2, 10, "Booting...", 0);
  led_write(Led1, LedOff);
  led_write(Led2, LedOff);
  led_write(LedG, LedOn);
  led_write(LedR, LedOff);

  rc = pf_mount(&fatfs);
  if (rc) {
    lcd_draw_string(2, 10, "SD mount failed.", 0);
    led_write(LedG, LedOff);
    led_write(LedR, LedOn);
    die(rc);
  }

  /*
   * SDɾOS᡼ɤ߹ߡ
   */
  puts("\n\nOpen kozos boot image.\n");
  rc = pf_open("kozos");
  if (rc) {
    lcd_draw_string(2, 10, "No boot image.", 0);
    led_write(LedG, LedOff);
    led_write(LedR, LedOn);
    die(rc);
  }

  puts("Reading...\n");
  loadbuf = (char *)(&buffer_start);
  for (;;) {
    rc = pf_read(buff, sizeof(buff), &br);
    if (rc || !br) {
      break;
    }
    for (i = 0; i < br; i++) {
      *loadbuf = buff[i];
      loadbuf++;
    }
  }
  if (rc) {
    puts("error.\n");
    lcd_draw_string(2, 10, "File read error.", 0);
    led_write(LedG, LedOff);
    led_write(LedR, LedOn);
    die(rc);
  }
  led_write(Led1, LedOff);
  led_write(Led2, LedOff);

  /*
   * Ÿ()
   */
  puts("Extracting...\n");
  loadbuf = (char *)(&buffer_start);
  entry_point = elf_load(loadbuf);

  /*
   * ¹ԡ
   */
  puts("Running...\n");
  if (!entry_point) {
    puts("error.\n");
    lcd_draw_string(2, 10, "Run error.", 0);
    led_write(LedG, LedOff);
    led_write(LedR, LedOn);
  } else {
    lcd_clear();
    led_write(Led1, LedOff);
    led_write(Led2, LedOff);
    led_write(LedG, LedOff);
    led_write(LedR, LedOff);
    f = (void (*)(void))entry_point;
    f();
  }

  for (;;) { }

  return 0;
}

