#include "defines.h"
#include "kozos.h"
#include "consdrv.h"
#include "timerdrv.h"
#include "leddrv.h"
#include "lib.h"

/* 󥽡롦ɥ饤ФλѳϤ򥳥󥽡롦ɥ饤Ф˰ꤹ */
static void send_use(int index)
{
  char *p;
  p = kz_kmalloc(3);
  p[0] = '0';
  p[1] = CONSDRV_CMD_USE;
  p[2] = '0' + index;
  kz_send(MSGBOX_ID_CONSOUTPUT, 3, p);
}

/* 󥽡ؤʸϤ򥳥󥽡롦ɥ饤Ф˰ꤹ */
static void send_write(char *str)
{
  char *p;
  int len;
  len = strlen(str);
  p = kz_kmalloc(len + 2);
  p[0] = '0';
  p[1] = CONSDRV_CMD_WRITE;
  memcpy(&p[2], str, len);
  kz_send(MSGBOX_ID_CONSOUTPUT, len + 2, p);
}

/* ޤΥȳϤ򥿥ޡɥ饤Ф˰ꤹ */
static void send_start(int msec)
{
  struct timerreq *req;
  req = kz_kmalloc(sizeof(*req));
  req->id = MSGBOX_ID_CONSINPUT;
  req->msec = msec;
  kz_send(MSGBOX_ID_TIMDRIVE, TIMERDRV_CMD_START, (char *)req);
}

static void send_led_toggle(int target)
{
  char *p;
  p = kz_kmalloc(2);
  p[0] = LEDDRV_CMD_LED_TOGGLE;
  p[1] = '0' + target;
  kz_send(MSGBOX_ID_LEDDRIVE, 2, p);
}

int command_main(int argc, char *argv[])
{
  char *p;
  int size;

  send_use(SERIAL_DEFAULT_DEVICE);

  while (1) {
    send_write("command> "); /* ץץɽ */

    /* 󥽡뤫μʸ */
    kz_recv(MSGBOX_ID_CONSINPUT, &size, &p);
    if (p == NULL) {
      send_write("expired.\n");
      continue;
    }
    p[size] = '\0';

    if (!strncmp(p, "echo", 4)) { /* echoޥ */
      send_write(p + 4); /* echo³ʸϤ */
      send_write("\n");
    } else if (!strncmp(p, "timer", 4)) { /* timerޥ */
      send_write("timer start.\n");
      send_start(1000);
    } else if (!strncmp(p, "led1", 4)) {
      send_led_toggle(0);
    } else if (!strncmp(p, "led2", 4)) {
      send_led_toggle(1);
    } else if (!strncmp(p, "ledg", 4)) {
      send_led_toggle(2);
    } else if (!strncmp(p, "ledr", 4)) {
      send_led_toggle(3);
    } else {
      send_write("unknown.\n");
    }

    kz_kmfree(p);
  }

  return 0;
}
