#include "defines.h"
#include "kozos.h"
#include "consdrv.h"
#include "timerdrv.h"
#include "leddrv.h"
#include "lib.h"
#include "sw.h"

/* ޤΥȳϤ򥿥ޡɥ饤Ф˰ꤹ */
static void send_start(int msec)
{
  struct timerreq *req;
  req = kz_kmalloc(sizeof(*req));
  req->id = MSGBOX_ID_TIMEXPIRE;
  req->msec = msec;
  kz_send(MSGBOX_ID_TIMDRIVE, TIMERDRV_CMD_START, (char *)req);
}

static void send_led_write(int target, int state)
{
  char *p;
  p = kz_kmalloc(2);
  p[0] = state ? LEDDRV_CMD_LED_ON : LEDDRV_CMD_LED_OFF;
  p[1] = '0' + target;
  kz_send(MSGBOX_ID_LEDDRIVE, 2, p);
}

static void send_led_toggle(int target)
{
  char *p;
  p = kz_kmalloc(2);
  p[0] = LEDDRV_CMD_LED_TOGGLE;
  p[1] = '0' + target;
  kz_send(MSGBOX_ID_LEDDRIVE, 2, p);
}

int clock_main(int argc, char *argv[])
{
  sw_init();

  while (1) {
    send_start(100);
    kz_recv(MSGBOX_ID_TIMEXPIRE, NULL, NULL);
    if (sw_read(Sw1)) {
      send_led_write(0, 1);
    } else {
      send_led_toggle(0);
    }

    send_start(100);
    kz_recv(MSGBOX_ID_TIMEXPIRE, NULL, NULL);
    if (sw_read(Sw2)) {
      send_led_write(1, 1);
    } else {
      send_led_toggle(1);
    }
  }

  return 0;
}
