#include "defines.h"
#include "interrupt.h"
#include "serial.h"
#include "xmodem.h"
#include "elf.h"
#include "dram.h"
#include "lib.h"
#include "led.h"
#include "re.h"

static int init(void)
{
  /* ʲϥ󥫡ץȤƤ륷ܥ */
  extern int erodata, data_start, edata, bss_start, ebss;

  /*
   * ǡΰBSSΰ롥νʹߤǤʤȡ
   * ХѿƤʤΤա
   */
  memcpy(&data_start, &erodata, (long)&edata - (long)&data_start);
  memset(&bss_start, 0, (long)&ebss - (long)&bss_start);

  /* եȥߥ٥ */
  softvec_init();

  /* ꥢν */
  serial_init(SERIAL_DEFAULT_DEVICE);

  /* DRAMν */
  dram_init();

  /* LEDν */
  led_init();

  /* ꡼󥳡ν */
  re_init();

  return 0;
}

/* 16ʥ׽ */
static int dump(char *buf, long size)
{
  long i;

  if (size < 0) {
    puts("no data.\n");
    return -1;
  }
  for (i = 0; i < size; i++) {
    putxval(buf[i], 2);
    if ((i & 0xf) == 15) {
      puts("\n");
    } else {
      if ((i & 0xf) == 7) puts(" ");
      puts(" ");
    }
  }
  puts("\n");

  return 0;
}

static void wait()
{
  volatile long i;
  for (i = 0; i < 300000; i++)
    ;
}

int main(void)
{
  static char buf[16];
  static long size = -1;
  static unsigned char *loadbuf = NULL;
  char *entry_point;
  void (*f)(void);
  extern int buffer_start; /* 󥫡ץȤƤХåե */

  INTR_DISABLE; /* ̵ˤ */

  init();

  puts("kzload (kozos boot loader) started.\n");

  while (1) {
    puts("kzload> "); /* ץץɽ */
    gets(buf); /* ꥢ뤫Υޥɼ */

    if (!strcmp(buf, "load")) { /* XMODEMǤΥեΥ */
      loadbuf = (char *)(&buffer_start);
      size = xmodem_recv(loadbuf);
      wait(); /* žץ꤬λüץ椬ޤԤ碌 */
      if (size < 0) {
	puts("\nXMODEM receive error!\n");
      } else {
	puts("\nXMODEM receive succeeded.\n");
      }
    } else if (!strcmp(buf, "dump")) { /* 16ʥ׽ */
      puts("size: ");
      putxval(size, 0);
      puts("\n");
      dump(loadbuf, size);
    } else if (!strcmp(buf, "run")) { /* ELFեμ¹ */
      entry_point = elf_load(loadbuf); /* Ÿ() */
      if (!entry_point) {
	puts("run error!\n");
      } else {
	puts("starting from entry point: ");
	putxval((unsigned long)entry_point, 0);
	puts("\n");
	f = (void (*)(void))entry_point;
	f(); /* ǡɤץ˽Ϥ */
	/* ˤ֤äƤʤ */
      }
    } else if (!strcmp(buf, "ramchk")) {
      dram_check();
    } else if (!strcmp(buf, "ramchk2")) {
      dram_check2();
    } else if (!strcmp(buf, "ramclr")) {
      dram_clear();
    } else if (!strcmp(buf, "led1")) {
      led_toggle(Led1);
    } else if (!strcmp(buf, "led2")) {
      led_toggle(Led2);
    } else if (!strcmp(buf, "ledg")) {
      led_toggle(LedG);
    } else if (!strcmp(buf, "ledr")) {
      led_toggle(LedR);
    } else if (!strcmp(buf, "re")) {
      puts("value: ");
      putxval(re_read(), 0);
      puts("\n");
    } else {
      puts("unknown.\n");
    }
  }

  return 0;
}
