package jp.kirikiri.tvp2env;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.VolatileImage;

public class VRAMImageBuffer {

	private Component mComponent;	// 描画対象となるコンポーネント
	private VolatileImage mVolatileImage;	// VRAMバッファ
	private int mWidth;		// VRAMバッファの幅
	private int mHeight;	// VRAMバッファの高さ

	public VRAMImageBuffer( Component cComponent ) {
		mComponent = cComponent;
	}

	public void initializeVolatileImage() {
		// VRAMバッファ用イメージが未作成、もしくは現在のサイズと異なっている場合は生成処理を実行する
		if( mVolatileImage == null || mWidth != mComponent.getWidth() || mHeight != mComponent.getHeight() ) {
			mWidth = mComponent.getWidth();
			mHeight = mComponent.getHeight();
			mVolatileImage = mComponent.createVolatileImage(mWidth, mHeight);
		}
	}

	public void validateVolatileImage() {
		// グラフィックス設定情報を取得する
		GraphicsConfiguration gc = mComponent.getGraphicsConfiguration();

		// VRAMバッファ用領域に変更があった場合は再度生成処理を実行する
		if( mVolatileImage.validate(gc) == VolatileImage.IMAGE_INCOMPATIBLE ) {
			mVolatileImage = mComponent.createVolatileImage(mWidth, mHeight);
		}
	}

	// グラフィックスオブジェクトの取得
	public Graphics getGraphics(){
		return mVolatileImage.getGraphics();
	}

	// 描画したコンテンツが失われているかのチェック
	public boolean isContentsLost() {
		return mVolatileImage.contentsLost();
	}

	// VRAMバッファイメージを返す
	public Image getImage(){
		return mVolatileImage;
	}
}
