package jp.kirikiri.tvp2.base;

import java.io.IOException;
import java.io.InputStream;

import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;

public class BinaryInputStream extends InputStream {

	private BinaryStream mStream;
	private long mMark;
	private byte[] mBuffer;

	public BinaryInputStream( BinaryStream stream ) {
		super();
		mStream = stream;
		mBuffer = new byte[1];
	}
	/**
	 *
     この入力ストリームのメソッドの次の呼び出しによって、ブロックせずにこの入力ストリームから読み込むことができる (またはスキップできる) 推定バイト数を返します。
	 */
	@Override
	public int available() {
		try {
			return (int) mStream.getSize();
		} catch (TJSException e) {
			return 0;
		}
	}
	/**
	 *
     この入力ストリームを閉じて、そのストリームに関連するすべてのシステムリソースを解放します。
	 */
	@Override
	public void close() {
		mStream.close();
	}
	/**
	 * この入力ストリームの現在位置にマークを設定します。
	 */
	@Override
	public void mark(int readlimit) {
		try {
			mMark = mStream.getPosition();
		} catch (TJSException e) {
		}
	}
	/**
	 * 入力ストリームが mark と reset メソッドをサポートしているかどうかを判定します。
	 */
	@Override
	public boolean markSupported() { return true; }

	/**
	 *
     入力ストリームからデータの次のバイトを読み込みます。
	 */
	@Override
	public int read() throws IOException {
		int ret;
		try {
			ret = mStream.read(mBuffer);
			if( ret < 0 ) return -1;
			ret = (int)mBuffer[0] & (int)0xff;
			return ret;
		} catch (TJSException e) {
			throw new IOException();
		}
	}
	/**
	 * 入力ストリームから数バイトを読み込み、それをバッファー配列 b に格納します。
	 */
	@Override
	public int read(byte[] b) {
		try {
			return mStream.read(b);
		} catch (TJSException e) {
			return -1;
		}
	}
	/**
	 * 最大 len バイトまでのデータを、入力ストリームからバイト配列に読み込みます。
	 */
	@Override
	public int read(byte[] b, int off, int len) {
		try {
			return mStream.read(b,off,len);
		} catch (TJSException e) {
			return -1;
		}
	}
	/**
	 * このストリームの位置を、入力ストリームで最後に mark メソッドが呼び出されたときのマーク位置に再設定します。
	 */
	@Override
	public void reset() {
		try {
			mStream.setPosition(mMark);
		} catch (TJSException e) {
		}
	}
	/**
	 *  この入力ストリームから n バイト分をスキップおよび破棄します
	 */
	@Override
	public long skip(long n) {
		try {
			long size = mStream.getSize();
			long pos = mStream.getPosition();
			if( (pos+n) > size ) n = size - pos;
			mStream.setPosition(pos+n);
			return n;
		} catch (TJSException e) {
			return 0;
		}

	}
}
