package jp.kirikiri.tvp2.visual;


import java.lang.ref.WeakReference;
import java.util.ArrayList;

import jp.kirikiri.tjs2.Error;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.EventManager;
import jp.kirikiri.tvp2.base.WindowEvents;
import jp.kirikiri.tvp2.env.DrawTarget;
import jp.kirikiri.tvp2.env.NativeImageBuffer;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.DebugClass;

public abstract class BaseWindowNI extends NativeInstanceObject implements WindowInterface {

	private ArrayList<VariantClosure> mObjectVector;
	private boolean mObjectVectorLocked;
	//protected Dispatch2 mOwner;
	protected WeakReference<Dispatch2> mOwner;

	protected Rect mWindowExposedRegion;
	//protected BaseBitmap mDrawBuffer;
	protected boolean mWindowUpdating; // window is in updating

	private DrawTarget mTargetWindow;
	protected NativeImageBuffer mOffscreenBuffer;
	private boolean mIsMainWindow;
	private boolean mDrawUpdateRectangle = false; // TODO debug

	/*
	public Variant mDrawDeviceObject; //!< Current Draw Device TJS2 Object
	public DrawDevice mDrawDevice; //!< Current Draw Device
	public void setDrawDeviceObject( Variant val ) {
		// invalidate existing draw device
		if( mDrawDeviceObject.isObject() )
			mDrawDeviceObject.asObjectClosure().invalidate(0, null, mDrawDeviceObject.asObject() );

		// assign new device
		mDrawDeviceObject = val;
		mDrawDevice = null;

		// extract interface
		if( mDrawDeviceObject.isObject() ) {
			VariantClosure clo = mDrawDeviceObject.asObjectClosure();
			Variant iface_v = new Variant();
			int hr = clo.propGet( 0, "interface", iface_v, null );
			if( hr < 0 )
				Message.throwExceptionMessage( "Could not retrive interface from given draw device" );
			mDrawDevice = iface_v.toJavaObject();
			mDrawDevice.setWindowInterface( this );
			resetDrawDevice();
		}
	}
	public Variant getDrawDeviceObject() { return mDrawDeviceObject; }
	public DrawDevice getDrawDevice() { return mDrawDevice; }
	public abstract void resetDrawDevice();
	*/

	public Dispatch2 getOwner() { return mOwner.get(); }
	@Override
	public Dispatch2 getWindowDispatch() {
		if( mOwner != null ) return mOwner.get();
		return null;
	}
	abstract void createOffscreenImage();

	public BaseWindowNI() {
		mObjectVector = new ArrayList<VariantClosure>();
		//mObjectVectorLocked = false;

		//mMenuItemObject = null;
		mWindowExposedRegion = new Rect();
		//mWindowExposedRegion.clear();
		//mWindowUpdating = false;

		mManagers = new ArrayList<LayerManager>();
		mDestRect = new Rect();
	}
	protected void finalize() {
		//TVPUnregisterWindowToList( this );
	}

	@Override
	public int construct( Variant[] param, Dispatch2 tjs_obj ) {
		mOwner = new WeakReference<Dispatch2>(tjs_obj); // no addref
		TVP.WindowList.registerWindowToList( (WindowNI) this );

		// set default draw device object "PassThrough"
		/* draw device は使わないでいけるかな
		{
			Dispatch2 cls = null ;
			Dispatch2 newobj = null ;
			try {
				cls = new tTJSNC_PassThroughDrawDevice();
				if(TJS_FAILED(cls->CreateNew(0, NULL, NULL, &newobj, 0, NULL, cls)))
					TVPThrowExceptionMessage(TVPInternalError,
						TJS_W("tTJSNI_Window::Construct"));
				SetDrawDeviceObject(tTJSVariant(newobj, newobj));
			} catch(...) {
				if(cls) cls->Release();
				if(newobj) newobj->Release();
				throw;
			}
			if(cls) cls->Release();
			if(newobj) newobj->Release();
		}
		*/
		return Error.S_OK;
	}
	@Override
	public void invalidate() throws VariantException, TJSException {
		// remove from list
		TVP.WindowList.unregisterWindowToList( (WindowNI) this );

		// remove all events
		TVP.EventManager.cancelSourceEvents( mOwner.get() );
		TVP.EventManager.cancelInputEvents( this );

		// clear all window update events
		TVP.EventManager.removeWindowUpdate( this );

		// free DrawBuffer
		//if( mDrawBuffer != null ) mDrawBuffer = null;

		// disconnect all VideoOverlay objects
		/*
		{
			tObjectListSafeLockHolder<tTJSNI_BaseVideoOverlay> holder(VideoOverlay);
			tjs_int count = VideoOverlay.GetSafeLockedObjectCount();
			for(tjs_int i = 0; i < count; i++)
			{
				tTJSNI_BaseVideoOverlay * item = VideoOverlay.GetSafeLockedObjectAt(i);
				if(!item) continue;

				item->Disconnect();
			}
		}
		*/

		// invalidate all registered objects
		mObjectVectorLocked = true;
		final int count = mObjectVector.size();
		for( int i = 0; i < count; i++ ) {
			// invalidate each --
			// objects may throw an exception while invalidating,
			// but here we cannot care for them.
			VariantClosure clo = mObjectVector.get(i);
			try {
				clo.invalidate(0, null, null);
				clo = null;
			} catch( TJSException e ) {
				DebugClass.addLog(e.getMessage()); // just in case, log the error
			}
		}

		// invalidate menu object
		if( mMenuItemObject != null ) {
			mMenuItemObject.invalidate( 0, null, mMenuItemObject );
			mMenuItemObject = null;
		}

		// remove all events (again)
		//TVPCancelSourceEvents( mOwner );
		//TVPCancelInputEvents( this );

		// clear all window update events (again)
		//TVPRemoveWindowUpdate( this );

		// release draw device
		// setDrawDeviceObject( new Variant() );


		super.invalidate();
		/* NOTE: at this point, Owner is still non-null.
		   Caller must ensure that the Owner being null at the end of the
		   invalidate chain. */
	}

	public boolean isMainWindow() { return TVP.MainWindow == this; }

	abstract protected boolean getWindowActive();

	public void fireOnActivate(boolean activate_or_deactivate) {
		// fire Window.onActivate or Window.onDeactivate event
		TVP.EventManager.postInputEvent( new WindowEvents.OnWindowActivateEvent(this, activate_or_deactivate), EventManager.EPT_REMOVE_POST );
		// to discard redundant events
	}

	abstract public boolean canDeliverEvents(); // implement this in each platform

	public void onClose() {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			Variant[] arg = new Variant[1];
			arg[0] = new Variant(1); // true
			TVP.EventManager.postEvent( owner, owner, "onCloseQuery", 0, EventManager.EPT_IMMEDIATE, arg);
		}
	}
	public void onResize() {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			TVP.EventManager.postEvent( owner, owner, "onResize", 0, EventManager.EPT_IMMEDIATE, TJS.NULL_ARG );
		}
	}
	public void onClick( int x, int y ) throws TJSException {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			Variant[] arg = new Variant[2];
			arg[0] = new Variant(x);
			arg[1] = new Variant(y);
			TVP.EventManager.postEvent( owner, owner, "onClick", 0, EventManager.EPT_IMMEDIATE, arg);
		}

		Point pos = new Point(x,y);
		if(!transformToPrimaryLayerManager(pos)) return;
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(manager==null) return;
		manager.notifyClick(pos.x, pos.y);
	}
	public void onDoubleClick( int x, int y ) throws TJSException {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			Variant[] arg = new Variant[2];
			arg[0] = new Variant(x);
			arg[1] = new Variant(y);
			TVP.EventManager.postEvent( owner, owner, "onDoubleClick", 0, EventManager.EPT_IMMEDIATE, arg);
		}

		Point pos = new Point(x,y);
		if(!transformToPrimaryLayerManager(pos)) return;
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(manager==null) return;
		manager.notifyDoubleClick(pos.x, pos.y);
	}
	public void onMouseDown( int x, int y, int mb, int flags ) throws TJSException {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			Variant[] arg = new Variant[4];
			arg[0] = new Variant(x);
			arg[1] = new Variant(y);
			arg[2] = new Variant(mb);
			arg[3] = new Variant(flags);
			TVP.EventManager.postEvent( owner, owner, "onMouseDown", 0, EventManager.EPT_IMMEDIATE, arg);
		}

		Point pos = new Point(x,y);
		if(!transformToPrimaryLayerManager(pos)) return;
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(manager==null) return;
		manager.notifyMouseDown(pos.x, pos.y, mb, flags );
	}
	public void onMouseUp( int x, int y, int mb, int flags) throws TJSException {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			Variant[] arg = new Variant[4];
			arg[0] = new Variant(x);
			arg[1] = new Variant(y);
			arg[2] = new Variant(mb);
			arg[3] = new Variant(flags);
			TVP.EventManager.postEvent( owner, owner, "onMouseUp", 0, EventManager.EPT_IMMEDIATE, arg);
		}

		Point pos = new Point(x,y);
		if(!transformToPrimaryLayerManager(pos)) return;
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(manager==null) return;
		manager.notifyMouseUp(pos.x, pos.y, mb, flags );
	}
	public void onMouseMove( int x, int y, int flags ) throws TJSException {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			Variant[] arg = new Variant[3];
			arg[0] = new Variant(x);
			arg[1] = new Variant(y);
			arg[2] = new Variant(flags);
			TVP.EventManager.postEvent( owner, owner, "onMouseMove", 0, EventManager.EPT_IMMEDIATE, arg);
		}

		Point pos = new Point(x,y);
		if(!transformToPrimaryLayerManager(pos)) return;
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(manager==null) return;
		manager.notifyMouseMove(pos.x, pos.y, flags );
	}
	public void onReleaseCapture() {
		if(!canDeliverEvents()) return;

		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(manager==null) return;
		manager.releaseCapture();
	}
	public void onMouseOutOfWindow() throws TJSException {
		if(!canDeliverEvents()) return;

		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(manager==null) return;
		manager.notifyMouseOutOfWindow();
	}
	public void onMouseEnter() {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			TVP.EventManager.postEvent( owner, owner, "onMouseEnter", 0, EventManager.EPT_IMMEDIATE, TJS.NULL_ARG );
		}
	}
	public void onMouseLeave() {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			TVP.EventManager.postEvent( owner, owner, "onMouseLeave", 0, EventManager.EPT_IMMEDIATE, TJS.NULL_ARG );
		}
	}
	public void onKeyDown( int key, int shift ) throws TJSException {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			Variant[] arg = new Variant[2];
			arg[0] = new Variant(key);
			arg[1] = new Variant(shift);
			TVP.EventManager.postEvent( owner, owner, "onKeyDown", 0, EventManager.EPT_IMMEDIATE, arg);
		}

		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(manager==null) return;
		manager.notifyKeyDown(key,shift);
	}
	public void onKeyUp( int key, int shift ) {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			Variant[] arg = new Variant[2];
			arg[0] = new Variant(key);
			arg[1] = new Variant(shift);
			TVP.EventManager.postEvent( owner, owner, "onKeyUp", 0, EventManager.EPT_IMMEDIATE, arg);
		}

		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(manager==null) return;
		manager.notifyKeyUp(key,shift);
	}
	public void onKeyPress( char key ) {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			Variant[] arg = new Variant[1];
			arg[0] = new Variant( String.valueOf(key) );
			TVP.EventManager.postEvent( owner, owner, "onKeyPress", 0, EventManager.EPT_IMMEDIATE, arg);
		}

		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(manager==null) return;
		manager.notifyKeyPress(key);
	}
	public void onFileDrop( final Variant array ) {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			Variant[] arg = new Variant[1];
			arg[0] = array;
			TVP.EventManager.postEvent( owner, owner, "onFileDrop", 0, EventManager.EPT_IMMEDIATE, arg);
		}
	}
	public void onMouseWheel( int shift, int delta, int x, int y ) {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			Variant[] arg = new Variant[4];
			arg[0] = new Variant(shift);
			arg[1] = new Variant(delta);
			arg[2] = new Variant(x);
			arg[3] = new Variant(y);
			TVP.EventManager.postEvent( owner, owner, "onMouseWheel", 0, EventManager.EPT_IMMEDIATE, arg);
		}

		Point pos = new Point(x,y);
		if(!transformToPrimaryLayerManager(pos)) return;
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(manager==null) return;
		manager.notifyMouseWheel(shift,delta, pos.x, pos.y );
	}
	public void onPopupHide() {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			TVP.EventManager.postEvent( owner, owner, "onPopupHide", 0, EventManager.EPT_IMMEDIATE, TJS.NULL_ARG );
		}
	}
	public void onActivate(boolean activate_or_deactivate) {
		if(!canDeliverEvents()) return;
		Dispatch2 owner = mOwner.get();
		if( owner != null ) {
			// re-check the window activate state
			if( getWindowActive() == activate_or_deactivate ) {
				if( activate_or_deactivate )
					TVP.EventManager.postEvent( owner, owner, "onActivate", 0, EventManager.EPT_IMMEDIATE, TJS.NULL_ARG );
				else
					TVP.EventManager.postEvent( owner, owner, "onDeactivate", 0, EventManager.EPT_IMMEDIATE, TJS.NULL_ARG );
			}
		}
	}

	public void clearInputEvents() {
		TVP.EventManager.cancelInputEvents(this);
	}

	public void postReleaseCaptureEvent() {
		TVP.EventManager.postInputEvent( new WindowEvents.OnReleaseCaptureInputEvent(this), 0 );
	}

	//----- layer managermant
	public void registerLayerManager( LayerManager manager ) {
		//addLayerManager(manager);
		mManagers.add( manager );
	}
	public void unregisterLayerManager( LayerManager manager ) throws TJSException {
		//removeLayerManager(manager);
		final int count = mManagers.size();
		for( int i = 0; i < count; i++ ) {
			LayerManager man = mManagers.get(i);
			if( manager == man ) {
				mManagers.remove(i);
				return;
			}
		}
		Message.throwExceptionMessage( Message.InternalError );
	}

	public void notifyWindowExposureToLayer( final Rect cliprect ) {
		requestInvalidation( cliprect);
	}
	/*
	public void notifyWindowExposureToLayer(const tTVPRect &cliprect)
	{
		DrawDevice->RequestInvalidation(cliprect);
	}
	*/

	public void notifyUpdateRegionFixed( final ComplexRect updaterects ) { // is called by layer manager
		// is called by layer manager
		beginUpdate(updaterects);
	}

	public void updateContent() throws VariantException, TJSException { // is called from event dispatcher
		// is called from event dispatcher
		update();
		show();

	 	endUpdate();
	}
	public void deliverDrawDeviceShow() {
		show();
	}
	public void beginUpdate( final ComplexRect rects ) {
		mWindowUpdating = true;
	}
	public void endUpdate() {
		mWindowUpdating = false;
	}
	@Override
	public void requestUpdate() {
		// is called from primary layer

		// post update event to self
		TVP.EventManager.postWindowUpdate((WindowNI)this);
	}
	@Override
	public void notifySrcResize() throws TJSException { // is called from primary layer
		// is called from primary layer
		if(mWindowUpdating)
			Message.throwExceptionMessage(Message.InvalidMethodInUpdating);
	}
	abstract public int getDefaultImeMode();

	public void dumpPrimaryLayerStructure() {
		dumpLayerStructure();
	}

	private void dumpLayerStructure() {
		// すべての layer manager の DumpLayerStructure を呼ぶ
		final int count = mManagers.size();
		for( int i  = 0; i < count; i++ ) {
			LayerManager m = mManagers.get(i);
			m.dumpLayerStructure();
		}
	}
	public void recheckInputState() throws TJSException { // slow timer tick (about 1 sec interval, inaccurate)
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(manager==null) return;

		manager.recheckInputState();
	}

	public void setShowUpdateRect( boolean b ) {
		mDrawUpdateRectangle = b;
	}


	//----- methods
	public void add( VariantClosure clo ) {
		if(mObjectVectorLocked) return;
		int idx = mObjectVector.indexOf(clo);
		if( idx < 0 ) {
			mObjectVector.add( clo );
		}
	}
	public void remove( VariantClosure clo ) {
		if(mObjectVectorLocked) return;
		int idx = mObjectVector.indexOf(clo);
		if( idx >= 0 ) {
			mObjectVector.remove( idx );
		}
	}

	//----- interface to menu object
	private Dispatch2 mMenuItemObject;
	public Dispatch2 getMenuItemObject() throws TJSException {
		if( mMenuItemObject != null ) return mMenuItemObject;

		// create MenuItemObect
		Dispatch2 owner = mOwner.get();
		if(owner==null) Message.throwExceptionMessage( Message.InternalError, "BaseWindowNI.getMenuItemObject" );
		mMenuItemObject = TVP.createMenuItemObject(owner);
		return mMenuItemObject;
	}

	//----- interface to video overlay object
	//protected ArrayList<BaseVideoOverlayNI> mVideoOverlay;
	//public void registerVideoOverlayObject(BaseVideoOverlayNI ovl);
	//public void unregisterVideoOverlayObject(BaseVideoOverlayNI ovl);

	// draw device 関係 start, オリジナルは分離しているけど、ここではくっつけてしまう
	protected int mPrimaryLayerManagerIndex; //!< プライマリレイヤマネージャ
	private ArrayList<LayerManager> mManagers; //!< レイヤマネージャの配列
	private Rect mDestRect; //!< 描画先位置

	private boolean mShouldShow;

	LayerNI getPrimaryLayer() {
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( manager == null ) return null;
		return manager.getPrimaryLayer();
	}
	public LayerManager getLayerManagerAt( int index ) {
		if( mManagers.size() <= index ) return null;
		return mManagers.get(index);
	}
	public LayerNI getFocusedLayer() {
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( manager == null ) return null;
		return manager.getFocusedLayer();
	}
	public void setFocusedLayer( LayerNI layer ) throws TJSException {
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( manager == null ) return;
		manager.setFocusedLayer(layer);
	}
	private void requestInvalidation( final Rect rect ) {
		Point lt = new Point( rect.left, rect.top);
		Point rb = new Point( rect.right, rect.bottom);
		if(!transformToPrimaryLayerManager(lt)) return;
		if(!transformToPrimaryLayerManager(rb)) return;
		rb.x++; // 誤差の吸収(本当はもうちょっと厳密にやらないとならないがそれが問題になることはない)
		rb.y++;

		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( manager == null ) return;
		manager.requestInvalidation( new Rect(lt.x, lt.y, rb.x, rb.y ) );
	}

	private void show() {
		mTargetWindow.show();
		/*
		if( mOffscreenBuffer != null && mShouldShow ) {
			mTargetWindow.drawImage( mOffscreenBuffer );
			mShouldShow = false;
		}
		*/
	}
	private void update() throws VariantException, TJSException {
		// すべての layer manager の UpdateToDrawDevice を呼ぶ
		final int count = mManagers.size();
		for( int i = 0; i < count; i++ ) {
			LayerManager m = mManagers.get(i);
			m.updateToDrawDevice();
		}
	}
	public void setImeMode(LayerManager manager, int mode ) {
		LayerManager primary_manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( primary_manager == null ) return;
		if( primary_manager == manager ) {
			setImeMode(mode);
		}
	}
	public void resetImeMode( LayerManager manager ) {
		LayerManager primary_manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( primary_manager == null ) return;
		if( primary_manager == manager ) {
			resetImeMode();
		}
	}
	public void setAttentionPoint( LayerManager manager, LayerNI layer, Point pt ) {
		LayerManager primary_manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( primary_manager == null ) return;
		if( primary_manager == manager ) {
			if( transformFromPrimaryLayerManager(pt) )
				setAttentionPoint(layer, pt );
		}
	}
	private boolean transformToPrimaryLayerManager( Point pt ) {
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( manager == null ) return false;

		// プライマリレイヤマネージャのプライマリレイヤのサイズを得る
		Size pl = new Size();
		if(!manager.getPrimaryLayerSize(pl)) return false;

		// x , y は DestRect の 0, 0 を原点とした座標として渡されてきている
		int w = mDestRect.width();
		int h = mDestRect.height();
		pt.x = w != 0 ? (pt.x * pl.width / w) : 0;
		pt.y = h != 0 ? (pt.y * pl.height / h) : 0;
		return true;
	}
	private boolean transformFromPrimaryLayerManager( Point pt ) {
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( manager == null ) return false;

		// プライマリレイヤマネージャのプライマリレイヤのサイズを得る
		Size pl = new Size();
		if(!manager.getPrimaryLayerSize(pl)) return false;

		// x , y は DestRect の 0, 0 を原点とした座標として渡されてきている
		pt.x = pl.width != 0 ? (pt.x * mDestRect.width()  / pl.width) : 0;
		pt.y = pl.height != 0 ? (pt.y * mDestRect.height() / pl.height) : 0;

		return true;
	}
	public void disableAttentionPoint( LayerManager manager ) {
		LayerManager primary_manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( primary_manager == null ) return;
		if( primary_manager == manager ) {
			disableAttentionPoint();
		}
	}
	public void notifyLayerImageChange( LayerManager manager ) {
		LayerManager primary_manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( primary_manager == manager )
			requestUpdate();
	}
	public void setTargetWindow(DrawTarget target, boolean ismain) {
		// TVPInitPassThroughOptions();
		// destroyDrawer();
		mTargetWindow = target;
		mIsMainWindow = ismain;
		//createOffscreenImage();
	}
	public void notifyBitmapCompleted(LayerManager layerManager, int x, int y,
			NativeImageBuffer nativeImageBuffer, Rect cliprect, int type, int opacity) {
		// TODO 自動生成されたメソッド・スタブ
		// nativeImageBuffer をオフスクリーンに描画する
		// show で実際のdrawdeviceへ転送する
		/*
		if( mOffscreenBuffer != null ) {
			mShouldShow = true;
			mOffscreenBuffer.copyRect(x, y, nativeImageBuffer, cliprect );
		}
		*/
		mTargetWindow.drawImage(x, y, nativeImageBuffer, cliprect, type, opacity );

		if( mDrawUpdateRectangle ) {
			int rleft   = x;
			int rtop    = y;
			int rright  = rleft + cliprect.width();
			int rbottom = rtop  + cliprect.height();

			Point[] points = new Point[4];
			points[0] = new Point( rleft, rtop );
			points[1] = new Point( rright -1, rtop );
			points[2] = new Point( rright -1, rbottom -1 );
			points[3] = new Point( rleft, rbottom -1 );
			mTargetWindow.drawLines( points, 0xffff00 );
			points = null;
		}
	}
	public void windowReleaseCapture(LayerManager manager) {
		LayerManager primary_manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( primary_manager == null ) return;
		if( primary_manager == manager ) {
			windowReleaseCapture();
		}
	}
	public void notifyLayerResize(LayerManager manager) throws TJSException {
		LayerManager primary_manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(primary_manager == manager)
			notifySrcResize();
	}
	public void startBitmapCompletion(LayerManager manager) {
		/*
		EnsureDrawer();

		// この中で DestroyDrawer が呼ばれる可能性に注意すること
		if(Drawer) Drawer->StartBitmapCompletion();

		if(!Drawer)
		{
			// リトライする
			EnsureDrawer();
			if(Drawer) Drawer->StartBitmapCompletion();
		}
		*/
	}
	public void endBitmapCompletion(LayerManager manager) {
		//if(Drawer) Drawer->EndBitmapCompletion();
	}
	public void setDestRectangle( final Rect rect ) {
		mDestRect.set( rect );
	}
	public void setCursorPos(LayerManager manager, int x, int y) {
		LayerManager primary_manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(primary_manager==null) return;
		if(primary_manager == manager) {
			Point pos = new Point(x,y);
			if(transformFromPrimaryLayerManager(pos) )
				setCursorPos(pos.x, pos.y);
		}
	}
	public void setDefaultMouseCursor(LayerManager manager) {
		LayerManager primary_manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(primary_manager==null) return;
		if(primary_manager == manager) {
			setDefaultMouseCursor();
		}
	}
	public void setMouseCursor(LayerManager manager, int cursor) {
		LayerManager primary_manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(primary_manager==null) return;
		if(primary_manager == manager) {
			setMouseCursor(cursor);
		}
	}
	public void getCursorPos(LayerManager manager, Point pos) {
		LayerManager primary_manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(primary_manager==null) return;
		getCursorPos(pos);
		if( primary_manager != manager || !transformToPrimaryLayerManager(pos) ) {
			// プライマリレイヤマネージャ以外には座標 0,0 で渡しておく
			pos.x = 0;
			pos.y = 0;
		}
	}
	public void setHintText(LayerManager manager, String text) {
		LayerManager primary_manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if(primary_manager==null) return;
		if(primary_manager == manager) {
			setHintText(text);
		}
	}
}
