package jp.kirikiri.tvp2env;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.BaseTransHandler;
import jp.kirikiri.tvp2.visual.SimpleImageProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;
import jp.kirikiri.tvp2.visual.TransHandlerProvider;

public class CrossFadeTransHandlerProvider implements TransHandlerProvider {

	protected long[] mLogValueRet;
	protected static final String TIME = "time";

	public CrossFadeTransHandlerProvider() {
		mLogValueRet = new long[1];
	}

	@Override
	public String getName() { return "crossfade"; }

	@Override
	public BaseTransHandler startTransition(SimpleOptionProvider options,
			SimpleImageProvider imagepro, int layertype, int src1w, int src1h,
			int src2w, int src2h, int[] type) throws TJSException {

		if( type != null && type.length >= 1 ) type[0] = ttExchange; // transition type : exchange
		if( type != null && type.length >= 2 ) type[1] = tutDivisibleFade;
			// update type : divisible fade
		if( options == null ) return null;

		if(src1w != src2w || src1h != src2h)
			Message.throwExceptionMessage( Message.TransitionLayerSizeMismatch,
				 String.valueOf(src2w) + "x" + src2h,
				 String.valueOf(src1w) + "x" + src1h );

		return getTransitionObject(options, imagepro, layertype, src1w, src1h, src2w, src2h);
	}

	protected BaseTransHandler getTransitionObject( SimpleOptionProvider options,
			SimpleImageProvider imagepro, int layertype, int src1w, int src1h,
			int src2w, int src2h ) throws TJSException {

		int er = options.getAsNumber( TIME, mLogValueRet );
		long time = mLogValueRet[0];
		if( er < 0 ) Message.throwExceptionMessage( Message.SpecifyOption, TIME );
		if(time < 2) time = 2; // too small time may cause problem

		return new CrossFadeTransHandler( options, layertype, time );
	}
}
