/*
 * TODO 未テスト
 */
package jp.kirikiri.tjs2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class NativeJavaClassProperty extends Dispatch {

	private Method mGet;
	private Method mSet;
	private Class<?> mParamType;
	private Class<?> mReturnType;
	private boolean mIsStaticGet;
	private boolean mIsStaticSet;
	private int mClassID;

	public NativeJavaClassProperty( Method get, Method set, int classID ) throws TJSException {
		mClassID = classID;
		mGet = get;
		if( get != null ) {
			mReturnType = get.getReturnType();
			if( mReturnType.equals(void.class) ) {
				throw new TJSException( Error.InternalError );
			}
			if( Modifier.isStatic( get.getModifiers() ) ) mIsStaticGet = true;
		}
		mSet = set;
		if( set != null ) {
			@SuppressWarnings("rawtypes")
			Class[] params = set.getParameterTypes();
			if( params.length == 1 ) {
				mParamType = params[0];
			} else {
				throw new TJSException( Error.InternalError );
			}
			if( Modifier.isStatic( set.getModifiers() ) ) mIsStaticSet = true;
		}
	}
	public int isInstanceOf( int flag, final String membername, final String classname, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername == null ) {
			if( "Property".equals(classname) ) return Error.S_TRUE;
		}
		return super.isInstanceOf(flag, membername, classname, objthis);
	}
	public int propGet( int flag, final String membername, Variant result, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername != null ) return super.propGet( flag, membername, result, objthis );

		if( result == null ) return Error.E_FAIL;
		if( mGet == null ) return Error.E_ACCESSDENYED;

		Object self;
		if( mIsStaticGet ) {
			self = null; // static 時は null
		} else {
			if( objthis == null ) return Error.E_NATIVECLASSCRASH;
			NativeJavaInstance ni = (NativeJavaInstance)objthis.getNativeInstance( mClassID );
			if( ni == null  ) return Error.E_FAIL;
			self = ni.getNativeObject();
			if( self == null ) return Error.E_NATIVECLASSCRASH;
		}
		int er = Error.S_OK;
		try {
			Object ret = mGet.invoke( self );
			NativeJavaClass.javaObjectToVariant( result, mReturnType, ret );
		} catch (IllegalArgumentException e) {
			er = Error.E_INVALIDPARAM;
		} catch (IllegalAccessException e) {
			er = Error.E_ACCESSDENYED;
		} catch (InvocationTargetException e) {
			Throwable t = e.getCause();
			if( t instanceof VariantException ) {
				throw (VariantException)t;
			} else if( t instanceof TJSException ) {
				throw (TJSException)t;
			} else {
				throw new TJSException( t.toString() );
			}
		}
		return er;
	}
	public int propSet( int flag, final String membername, final Variant param, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername != null ) return super.propSet(flag, membername, param, objthis);
		if( objthis == null ) return Error.E_NATIVECLASSCRASH;
		if( param == null ) return Error.E_FAIL;
		if( mSet == null ) return Error.E_ACCESSDENYED;

		Object self;
		if( mIsStaticSet ) {
			self = null; // static 時は null
		} else {
			NativeJavaInstance ni = (NativeJavaInstance)objthis.getNativeInstance( mClassID );
			if( ni == null ) return Error.E_FAIL;
			self = ni.getNativeObject();
			if( self == null ) return Error.E_NATIVECLASSCRASH;
		}
		int er = Error.S_OK;
		Object arg = NativeJavaClass.variantToJavaObject( param, mParamType );
		if( arg == null ) return Error.E_INVALIDPARAM;
		Object[] args = new Object[1];
		args[0] = arg;
		try {
			mSet.invoke( self, args );
		} catch (IllegalArgumentException e) {
			er = Error.E_INVALIDPARAM;
		} catch (IllegalAccessException e) {
			er = Error.E_ACCESSDENYED;
		} catch (InvocationTargetException e) {
			Throwable t = e.getCause();
			if( t instanceof VariantException ) {
				throw (VariantException)t;
			} else if( t instanceof TJSException ) {
				throw (TJSException)t;
			} else {
				throw new TJSException( t.toString() );
			}
		}
		return er;
	}
}
