package iax.client.protocol.call.command.send;

import iax.client.protocol.call.Call;
import iax.client.protocol.frame.ProtocolControlFrame;

/**
 * Sends an accept
 */
public class Accept implements CallCommandSend {
    // Call for sending the frame
    private Call call;

    private ProtocolControlFrame recvCallFrame;
    /**
     * Constructor
     * @param call call for sending the frame
     */
    public Accept(Call call, ProtocolControlFrame recvCallFrame) {
        this.call = call;
        this.recvCallFrame = recvCallFrame;
    }

    public void execute() {
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        call.handleSendFrame(new ProtocolControlFrame(call.getSrcCallNo(), 
                false, 
                call.getDestCallNo(), 
                recvCallFrame.getTimestamp(), 
                recvCallFrame.getOseqno(), 
                recvCallFrame.getIseqno(), 
                false, 
                ProtocolControlFrame.ACCEPT_SC));
    }
}
