/*
	$Id: PagerActions.cs 25 2010-01-17 19:55:07Z catwalk $
*/
using System;

namespace Hiyoko.Utilities{
	public class PagerActions{
		public Delegate PreviousInvoker{get; set;}
		public Delegate NextInvoker{get; set;}
		public Delegate CurrentInvoker{get; set;}
		public Delegate FirstInvoker{get; set;}
		public object State{get; set;}
		
		public PagerActions(Delegate previousInvoker, Delegate nextInvoker) : this(previousInvoker, nextInvoker, null, null, null){
		}
		
		public PagerActions(Delegate previousInvoker, Delegate nextInvoker, Delegate currentInvoker, Delegate firstInvoker) : this(previousInvoker, nextInvoker, currentInvoker, firstInvoker, null){
		}
		
		public PagerActions(Delegate previousInvoker, Delegate nextInvoker, Delegate currentInvoker, Delegate firstInvoker, object state){
			this.PreviousInvoker = previousInvoker;
			this.NextInvoker = nextInvoker;
			this.CurrentInvoker = currentInvoker;
			this.FirstInvoker = firstInvoker;
			this.State = state;
		}
		
		public bool CanNext{
			get{
				return (this.NextInvoker != null);
			}
		}
		
		public bool CanPrevious{
			get{
				return (this.PreviousInvoker != null);
			}
		}
		
		public bool CanCurrent{
			get{
				return (this.CurrentInvoker != null);
			}
		}
		
		public bool CanFirst{
			get{
				return (this.FirstInvoker != null);
			}
		}
		
		public object Next(params object[] args){
			if(!this.CanNext){
				throw new InvalidOperationException();
			}
			return this.NextInvoker.DynamicInvoke(args);
		}
		
		public object Previous(params object[] args){
			if(!this.CanPrevious){
				throw new InvalidOperationException();
			}
			return this.PreviousInvoker.DynamicInvoke(args);
		}
		
		public object Current(params object[] args){
			if(!this.CanCurrent){
				throw new InvalidOperationException();
			}
			return this.CurrentInvoker.DynamicInvoke(args);
		}
		
		public object First(params object[] args){
			if(!this.CanFirst){
				throw new InvalidOperationException();
			}
			return this.FirstInvoker.DynamicInvoke(args);
		}
	}
}