using System;
using System.Configuration;
using System.Windows;
using System.Windows.Data;
using System.Windows.Media;

namespace Hiyoko.Themes{
	public class Glass : ThemeBase{
		private ImageBrushSettings BackgroundImageSettings = null;
		
		public override string Name{
			get{
				return "Glass";
			}
		}
		
		public override string Description{
			get{
				return "Glassy theme for Windows Vista or later.";
			}
		}
		
		
		public override ResourceDictionary Resources{
			get{
				if(this.BackgroundImageSettings == null){
					this.BackgroundImageSettings = new ImageBrushSettings("GlassBackground");
					this.BackgroundImageSettings.UpgradeOnce();
				}
				var res = GetResources(new Uri("Hiyoko.Themes;component/Themes/Glass.xaml", UriKind.RelativeOrAbsolute));
				if(!String.IsNullOrEmpty(this.BackgroundImageSettings.ImageFile)){
					res["WindowBrush"] = this.BackgroundImageSettings.GetImageBrush();
				}
				return res;
			}
		}
		
		public override Guid Guid{
			get{
				return new Guid("{DF630FC8-D66A-48df-BC07-DB442F6056D8}");
			}
		}
		
		public override bool IsGlassWindow{
			get{
				return true;
			}
		}
		
		public override bool CanShowSettings{
			get{
				return true;
			}
		}
		
		public override bool? ShowSettings(Window owner){
			if(this.BackgroundImageSettings == null){
				this.BackgroundImageSettings = new ImageBrushSettings("GlassBackground");
				this.BackgroundImageSettings.UpgradeOnce();
			}
			return ImageBrushSettingsForm.Show(this.BackgroundImageSettings, "背景画像", owner);
		}
	}
}