/*
	$Id: Hiyoko.cs 84 2010-05-21 17:37:35Z catwalk $
*/
using System;
using System.Linq;
using System.IO;
using System.Windows;
using System.Windows.Input;
using System.Windows.Threading;
using System.Configuration;
using System.ComponentModel;
using System.Threading;
using System.Diagnostics;
using System.Net;
using System.Collections.ObjectModel;
using System.Collections.Generic;
using System.Reflection;
using Microsoft.Scripting.Hosting;
using IronPython.Hosting;
using Hiyoko.Forms;
using Hiyoko.Utilities;
using Hiyoko.Net;
using Hiyoko.Net.Twitter;
using Hiyoko.Themes;
using Microsoft.WindowsAPICodePack.Taskbar;

namespace Hiyoko{
	using IO = System.IO;
	
	public partial class Program : Application{
		private ScriptEngine pythonEngine = null;
		private ScriptScope pythonScope = null;
		private ApplicationSettings settings;
		private CommandLine commandLine;
		private NetworkJobServer networkJobServer;
		private string executablePath;
		private UrlShorter urlShorter;
		private ThemeManager themeManager;
		private MainForm mainForm;
		private Twitpic twitpic;
		private DispatcherTimer checkUpdatesTimer;
		
		protected override void OnStartup(StartupEventArgs e){
			if(!ApplicationProcess.IsFirst){
				ApplicationProcess.InvokeRemote("Show");
				this.Shutdown();
			}else{
				ApplicationProcess.Actions.Add("Show", new Action(delegate{
					this.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
						if(this.MainWindow != null){
							((MainForm)this.MainWindow).ShowWindow();
						}
					}));
				}));
				//System.Windows.Forms.Application.EnableVisualStyles();
				this.DispatcherUnhandledException += this.HandleUnhandleExceptions;
				
				// 
				this.commandLine = new CommandLine();
				this.networkJobServer = new NetworkJobServer();
				this.executablePath = System.Windows.Forms.Application.ExecutablePath;
				AvailableUpdates = new ReadOnlyCollection<UpdatePackage>(new UpdatePackage[0]);
				this.checkUpdatesTimer = new DispatcherTimer();
				this.checkUpdatesTimer.Interval = new TimeSpan(1, 0, 0);
				this.checkUpdatesTimer.Tick += delegate{
					CheckUpdates();
				};
				this.checkUpdatesTimer.Start();
				
				// ݒǂݍ
				this.settings = new ApplicationSettings("Application");
				this.settings.UpgradeOnce();
				this.settings.PropertyChanged += this.ApplicationSettings_Changed;
				if(this.settings.StartupScriptPath == null){
					this.settings.StartupScriptPath = Environment.GetFolderPath(Environment.SpecialFolder.Personal) + @"\HiyokoStartup.py";
				}
				this.InitalizeWebProxy();
				this.ApplyShutdownMode();
				this.networkJobServer.Timeout = Program.Settings.ConnectionTimeout;
				this.InitalizeUrlShorter();
				this.InitalizeTwitpic();

				// ThemeManager
				string path = IO.Path.GetDirectoryName(Program.ExecutablePath) + @"\Themes";
				this.themeManager = new ThemeManager();
				try {
					this.themeManager.LoadThemes(path);
					this.RefreshTheme();
				} catch {
				}

				// AJEgݒ
				if(this.settings.AccessToken == null){
					SettingsForm settings = new SettingsForm();
					settings.ShowInTaskbar = true;
					settings.authTab.IsSelected = true;
					settings.ShowDialog();
				}
				
				// MainForm
				this.mainForm = this.LoadMainForm();
				if(!(this.settings.IsResident && (this.commandLine.Options.ContainsKey("hide")))){
					this.mainForm.Show();
				}
				
				ThreadPool.QueueUserWorkItem(new WaitCallback(delegate{
					// IronPython
					this.pythonEngine = Python.CreateEngine(AppDomain.CurrentDomain);
					var thisAsm = Assembly.GetExecutingAssembly();
					this.pythonEngine.Runtime.LoadAssembly(thisAsm);
					foreach(var asmName in thisAsm.GetReferencedAssemblies()){
						this.pythonEngine.Runtime.LoadAssembly(Assembly.Load(asmName));
					}
					this.pythonScope = this.pythonEngine.CreateScope();

					// StartupXNvgs
					string[] scripts = new string[]{
						this.settings.StartupScriptPath,
						Path.GetDirectoryName(this.executablePath) + @"\DefaultStartup.py"
					}.Where(file => File.Exists(file)).Take(1).ToArray();
					this.Dispatcher.BeginInvoke(DispatcherPriority.Render, new Action(delegate{
						MainForm.Outputs.Add(new MessageOutputItem(String.Format("X^[gAbvXNvgs - {0}", scripts[0])));
					}));
					if(scripts.Length > 0){
						try{
							this.pythonEngine.ExecuteFile(scripts[0], this.pythonScope);
							this.Dispatcher.BeginInvoke(DispatcherPriority.Render, new Action(delegate{
								this.mainForm.Outputs.Add(new SuccessOutputItem("X^[gAbvXNvgs"));
							}));
						}catch(Exception ex){
							this.Dispatcher.BeginInvoke(DispatcherPriority.Render, new Action(delegate{
								this.mainForm.Outputs.Add(new ErrorOutputItem(ex.ToString()));
							}));
						}
					}
				}));
				
				if(this.settings.IsAutoCheckUpdates && ((DateTime.Now - this.settings.LastCheckedUpdatesDate).Days >= 1)){
					CheckUpdates();
				}
			}
			base.OnStartup(e);
		}
		
		#region 
		
		private void ApplyShutdownMode(){
			this.ShutdownMode = (this.settings.IsResident) ? ShutdownMode.OnExplicitShutdown : ShutdownMode.OnLastWindowClose;
		}
		
		private void InitalizeWebProxy(){
			if(this.settings.IsUseWebProxy && !String.IsNullOrEmpty(this.settings.WebProxyUriString)){
				try{
					var uri = new Uri(this.settings.WebProxyUriString);
					var proxy = new WebProxy(uri);
					if(!String.IsNullOrEmpty(uri.UserInfo)){
						string[] strs = uri.UserInfo.Split(new char[]{':'});
						if(strs.Length >= 2){
							proxy.Credentials = new NetworkCredential(strs[0], strs[1]);
						}
					}
					this.networkJobServer.Proxy = TwitterAPI.Proxy = proxy;
				}catch(UriFormatException ex){
					if(this.mainForm != null){
						this.mainForm.Outputs.Add(new ErrorOutputItem("vNVUrisłB\n" + ex.Message));
					}
				}
			}else{
				this.networkJobServer.Proxy = TwitterAPI.Proxy = WebRequest.DefaultWebProxy;
			}
		}
		
		private void RefreshTheme(){
			this.themeManager.CurrentTheme = null;
			var guid = Program.Settings.ThemeGuid;
			if(guid != Guid.Empty){
				try{
					var theme = this.themeManager.Themes.Where(t => (t.Guid == guid)).FirstOrDefault();
					if(theme != null){
						this.themeManager.CurrentTheme = theme;
						try{
							if((this.themeManager.CurrentTheme != null) && (this.themeManager.CurrentTheme.IsGlassWindow)){
								if(this.mainForm.AeroGlassCompositionEnabled){
									this.mainForm.SetAeroGlassTransparency();
								}
							}
						}catch{
						}
					}else{
						this.mainForm.Outputs.Add(new WarningOutputItem("e[}܂łB"));
					}
				}catch(Exception ex){
					this.mainForm.Outputs.Add(new ErrorOutputItem("e[}̓KpɎs܂B\n" + ex.Message));
				}
			}
		}
		
		private void InitalizeUrlShorter(){
			this.urlShorter = (String.IsNullOrEmpty(settings.BitlyApiKey)) ? null : new Bitly(settings.BitlyLogin, settings.BitlyApiKey);
		}
		
		private void InitalizeTwitpic(){
			this.twitpic = new Twitpic(Program.Settings.TwitpicUsername, Program.Settings.TwitpicPassword);
		}
		
		#endregion
		
		#region ֐
		
		private MainForm LoadMainForm(){
			MainForm mainForm = new MainForm();
			this.MainWindow = mainForm;
			return mainForm;
		}
		
		private void UnloadMainForm(){
			var mode = this.ShutdownMode;
			this.ShutdownMode = ShutdownMode.OnExplicitShutdown;
			MainForm mainForm = MainForm;
			mainForm.IsResident = false;
			mainForm.Close();
			this.ShutdownMode = mode;
		}
		
		#endregion
		
		#region Cxg
		
		protected override void OnExit(ExitEventArgs e){
			if(ApplicationProcess.IsFirst){
				this.settings.Save();
			}
			base.OnExit(e);
		}
		
		private void HandleUnhandleExceptions(object sender, DispatcherUnhandledExceptionEventArgs e){
		}
		
		private void ApplicationSettings_Changed(object sender, PropertyChangedEventArgs e){
			ApplicationSettings settings = (ApplicationSettings)sender;
			switch(e.PropertyName){
				case "ConnectionTimeout":{
					this.networkJobServer.Timeout = settings.ConnectionTimeout;
					break;
				}
				case "IsResident":{
					this.ApplyShutdownMode();
					break;
				}
				case "WebProxyUriString":
				case "IsUseWebProxy":{
					this.InitalizeWebProxy();
					break;
				}
				case "BitlyApiKey":
				case "BitlyLogin":{
					this.InitalizeUrlShorter();
					break;
				}
				case "ThemeGuid":{
					this.RefreshTheme();
					break;
				}
				case "TwitpicUsername":
				case "TwitpicPassword":{
					this.InitalizeTwitpic();
					break;
				}
				case "IsAutoCheckUpdates":{
					if(settings.IsAutoCheckUpdates && ((DateTime.Now - settings.LastCheckedUpdatesDate).Days >= 1)){
						CheckUpdates();
					}
					break;
				}
			}
		}
		
		#endregion
		
		#region Abvf[g
		
		public static UpdatePackage[] GetUpdates(){
			return GetUpdates(true);
		}
		
		private static UpdatePackage[] GetUpdates(bool showProgress){
			ProgressForm progress = null;
			try{
				if(showProgress){
					progress = new ProgressForm();
					progress.Message = "XVmFĂ܂B";
					progress.IsIndeterminate = true;
					progress.Owner = MainForm;
					progress.Show();
					if((MainForm != null) && TaskbarManager.IsPlatformSupported){
						TaskbarManager.Instance.SetProgressState(TaskbarProgressBarState.Indeterminate);
					}
				}
				var version = new Version(System.Windows.Forms.Application.ProductVersion);
				var updater = new AutoUpdater(new Uri("http://hiyoko.sourceforge.jp/updater/packages.xml"));
				var updates = updater.CheckUpdates().Where(p => p.Version > version)
				                                    .Where(p => p.State == PackageState.Stable).ToArray();
				Program.Settings.LastCheckedUpdatesDate = DateTime.Now;
				return updates;
			}finally{
				if(showProgress){
					progress.Close();
					if((MainForm != null) && TaskbarManager.IsPlatformSupported){
						TaskbarManager.Instance.SetProgressState(TaskbarProgressBarState.NoProgress);
					}
				}
			}
		}
		
		public static void Update(UpdatePackage package){
			var progress = new ProgressForm();
			progress.Message = "XVt@C_E[h";
			progress.IsIndeterminate = false;
			progress.Owner = MainForm;
			progress.Show();
			if((MainForm != null) && TaskbarManager.IsPlatformSupported){
				TaskbarManager.Instance.SetProgressState(TaskbarProgressBarState.Normal);
			}
			
			package.DownloadInstallerAsync(delegate(object sender, DownloadProgressChangedEventArgs e2){
				Application.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
					progress.Value = (double)e2.ProgressPercentage;
					if((MainForm != null) && TaskbarManager.IsPlatformSupported){
						TaskbarManager.Instance.SetProgressValue(e2.ProgressPercentage, 100);
					}
				}));
			}, delegate(object sender, AsyncCompletedEventArgs e2){
				Application.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, new Action(delegate{
					var file = (string)e2.UserState;
					progress.Close();
					if((MainForm != null) && TaskbarManager.IsPlatformSupported){
						TaskbarManager.Instance.SetProgressState(TaskbarProgressBarState.NoProgress);
					}
					MessageBox.Show("CXg[[s܂B");
					Process.Start(file);
					Application.Current.Shutdown();
				}));
			});
		}
		
		private static void CheckUpdates(){
			ThreadPool.QueueUserWorkItem(new WaitCallback(delegate{
				try{
					var updates = new ReadOnlyCollection<UpdatePackage>(GetUpdates(false));
					Application.Current.Dispatcher.BeginInvoke(DispatcherPriority.Background, new Action(delegate{
						AvailableUpdates = updates;
						Program.Settings.LastCheckedUpdatesDate = DateTime.Now;
					}));
				}catch(WebException){
				}
			}));
		}
		
		#endregion
		
		#region vpeB
		
		public static ReadOnlyCollection<UpdatePackage> AvailableUpdates{get; private set;}
		
		public static ScriptEngine PythonEngine{
			get{
				Program prog = Application.Current as Program;
				return (prog != null) ? prog.pythonEngine : null;
			}
		}

		public static ScriptScope PythonScope{
			get {
				Program prog = Application.Current as Program;
				return (prog != null) ? prog.pythonScope : null;
			}
		}

		public static MainForm MainForm{
			get{
				return Application.Current.MainWindow as MainForm;
			}
		}
		
		public static ApplicationSettings Settings{
			get{
				Program prog = Application.Current as Program;
				return (prog != null) ? prog.settings : null;
			}
		}
		
		public static NetworkJobServer NetworkJobServer{
			get{
				Program prog = Application.Current as Program;
				return (prog != null) ? prog.networkJobServer : null;
			}
		}
		
		public static string ExecutablePath{
			get{
				Program prog = Application.Current as Program;
				return (prog != null) ? prog.executablePath : null;
			}
		}
		
		public static UrlShorter UrlShorter{
			get{
				Program prog = Application.Current as Program;
				return (prog != null) ? prog.urlShorter : null;
			}
		}
		
		public static ThemeManager ThemeManager{
			get{
				Program prog = Application.Current as Program;
				return (prog != null) ? prog.themeManager : null;
			}
		}
		
		public static Twitpic Twitpic{
			get{
				Program prog = Application.Current as Program;
				return (prog != null) ? prog.twitpic : null;
			}
		}
		
		#endregion
	}
}