using System;
using System.Windows;
using System.Windows.Media;
using System.Reflection;

namespace Hiyoko.Themes{
	public interface ITheme{
		string Name{get;}
		string Description{get;}
		string Copyright{get;}
		Guid Guid{get;}
		Version Version{get;}
		ResourceDictionary Resources{get;}
		bool IsGlassWindow{get;}
		ImageSource PreviewImage{get;}
		bool CanShowSettings{get;}
		bool? ShowSettings();
		bool? ShowSettings(Window owner);
	}
	
	public abstract class ThemeBase : ITheme{
		public abstract string Name{get;}
		public abstract string Description{get;}
		public abstract ResourceDictionary Resources{get;}
		public abstract Guid Guid{get;}
		
		protected static ResourceDictionary GetResources(Uri uri){
			return Application.LoadComponent(uri) as ResourceDictionary;
		}
		
		public virtual string Copyright{
			get{
				Assembly asm = Assembly.GetEntryAssembly();
				object[] CopyrightArray = asm.GetCustomAttributes(typeof(AssemblyCopyrightAttribute), false);
				if((CopyrightArray != null) && (CopyrightArray.Length > 0)){
					return ((AssemblyCopyrightAttribute)CopyrightArray[0]).Copyright;
				}
				return "";
			}
		}
		
		public virtual Version Version{
			get{
				return Assembly.GetExecutingAssembly().GetName().Version;
			}
		}
		
		public virtual bool IsGlassWindow{
			get{
				return false;
			}
		}
		
		public virtual ImageSource PreviewImage{
			get{
				return null;
			}
		}
		
		public virtual bool CanShowSettings{
			get{
				return false;
			}
		}
		
		public virtual bool? ShowSettings(){
			return this.ShowSettings(null);
		}
		
		public virtual bool? ShowSettings(Window owner){
			throw new NotImplementedException();
		}
		
		public static readonly ITheme Empty = new EmptyTheme();
	}
	
	internal class EmptyTheme : ThemeBase{
		public override string Name{
			get{
				return "(None)";
			}
		}
		
		public override string Description{
			get{
				return "";
			}
		}
		
		public override ResourceDictionary Resources{
			get{
				return null;
			}
		}
		
		public override Guid Guid{
			get{
				return Guid.Empty;
			}
		}
		
		public override string Copyright{
			get{
				return "";
			}
		}
		
		public override Version Version{
			get{
				return null;
			}
		}
	}
}