/*
	$Id: DisposableObject.cs 25 2010-01-17 19:55:07Z catwalk $
*/
using System;

namespace Hiyoko{
	public abstract class DisposableObject : IDisposable{
		public void Dispose(){
			this.Dispose(true);
			GC.SuppressFinalize(this);
		}
		
		protected virtual void Dispose(bool disposing){
		}
		
		~DisposableObject(){
			this.Dispose(false);
		}
	}
}