/*
	$Id: User.cs 14 2010-01-06 17:27:40Z catwalk $
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Xml.Linq;
using System.Net;
using System.Net.NetworkInformation;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;

namespace Hiyoko.Net.Twitter{
	public class User{
		public decimal Id{get; private set;}
		public string Name{get; private set;}
		public string ScreenName{get; private set;}
		public string Location{get; private set;}
		public string Description{get; private set;}
		public string ProfileImageUrl{get; private set;}
		public string Url{get; private set;}
		public bool Protected{get; private set;}
		public int FollowersCount{get; private set;}
		public int ProfileBackgroundColor{get; private set;}
		public int ProfileTextColor{get; private set;}
		public int ProfileLinkColor{get; private set;}
		public int ProfileSidebarFillColor{get; private set;}
		public int ProfileSidebarBorderColor{get; private set;}
		public int FriendsCount{get; private set;}
		public DateTime CreatedAt{get; private set;}
		public int FavouritesCount{get; private set;}
		public int UtcOffset{get; private set;}
		public string TimeZone{get; private set;}
		public string ProfileBackgroundImageUrl{get; private set;}
		public bool ProfileBackgroundTile{get; private set;}
		public string Notifications{get; private set;}
		public bool GeoEnabled{get; private set;}
		public bool Verified{get; private set;}
		public string Following{get; private set;}
		public int StatusesCount{get; private set;}
		
		public User(XElement user){
			this.Id = (decimal)user.Element("id");
			this.Name = HttpUtility.UrlDecode((string)user.Element("name"), Encoding.UTF8);
			this.ScreenName = (string)user.Element("screen_name");
			this.Location = HttpUtility.UrlDecode((string)user.Element("location"), Encoding.UTF8);
			this.Description = HttpUtility.UrlDecode((string)user.Element("description"), Encoding.UTF8);
			this.ProfileImageUrl = (string)user.Element("profile_image_url");
			this.Url = (string)user.Element("url");
			this.Protected = (bool)user.Element("protected");
			this.FollowersCount = (int)user.Element("followers_count");
			
			this.ProfileBackgroundColor = Convert.ToInt32((string)user.Element("profile_background_color"), 16);
			this.ProfileTextColor = Convert.ToInt32((string)user.Element("profile_text_color"), 16);
			this.ProfileLinkColor = Convert.ToInt32((string)user.Element("profile_link_color"), 16);
			this.ProfileSidebarFillColor = Convert.ToInt32((string)user.Element("profile_sidebar_fill_color"), 16);
			this.ProfileSidebarBorderColor = Convert.ToInt32((string)user.Element("profile_sidebar_border_color"), 16);
			this.FriendsCount = (int)user.Element("friends_count");
			DateTime dt;
			if(TwitterAPI.TryParseDateTime((string)user.Element("created_at"), out dt)){
				this.CreatedAt = dt;
			}
			this.FavouritesCount = (int)user.Element("favourites_count");
			int n;
			if(Int32.TryParse((string)user.Element("utc_offset"), out n)){
				this.UtcOffset = n;
			}
			this.TimeZone = (string)user.Element("time_zone");
			this.ProfileBackgroundImageUrl = (string)user.Element("profile_background_image_url");
			this.ProfileBackgroundTile = (bool)user.Element("profile_background_tile");
			this.Notifications = (string)user.Element("notifications");
			this.GeoEnabled = (bool)user.Element("geo_enabled");
			this.Verified = (bool)user.Element("verified");
			this.Following = (string)user.Element("following");
			this.StatusesCount = (int)user.Element("statuses_count");
		}
		
		public override bool Equals(object obj){
			User user = obj as User;
			if(user != null){
				return this.Id.Equals(user.Id);
			}else{
				return false;
			}
		}
		
		public override int GetHashCode(){
			return this.Id.GetHashCode();
		}
	}
}