from System import *;
from System.Windows import *;
from System.Windows.Input import *;
from System.Windows.Threading import *;
from Hiyoko import *;

def Startup(sender):
	mainForm = Application.Current.MainWindow;
	BindKeys(mainForm);
	RefreshTimeline(mainForm);

def BindKeys(mainForm):
	mainForm.InputBindings.Add(KeyBinding(HiyokoCommands.Close, KeyGesture(Key.W, ModifierKeys.Control)));
	mainForm.InputBindings.Add(KeyBinding(HiyokoCommands.AbortCommunication, KeyGesture(Key.Escape, ModifierKeys.None, "Esc")));
	mainForm.InputBindings.Add(KeyBinding(HiyokoCommands.Refresh, Key.F5, ModifierKeys.None));
	
	mainForm.StatusEdit.InputBindings.Add(KeyBinding(HiyokoCommands.UpdateStatus, Key.Enter, ModifierKeys.Control));
	mainForm.StatusEdit.InputBindings.Add(KeyBinding(ComponentCommands.ScrollPageUp, Key.PageUp, ModifierKeys.None));
	mainForm.StatusEdit.InputBindings.Add(KeyBinding(ComponentCommands.ScrollPageDown, Key.PageDown, ModifierKeys.None));
	
	mainForm.TimelineList.InputBindings.Add(KeyBinding(ApplicationCommands.Copy, Key.C, ModifierKeys.Control));
	mainForm.TimelineList.InputBindings.Add(KeyBinding(ApplicationCommands.Copy, Key.Insert, ModifierKeys.Control));
	mainForm.TimelineList.MouseDoubleClick += TimelineList_MouseDoubleClick;

def RefreshTimeline(mainForm):
	HiyokoCommands.Refresh.Execute(None, mainForm.TimelineList);

def TimelineList_MouseDoubleClick(listBox, e):
	HiyokoCommands.OpenUrls.Execute(None, listBox);

Application.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, Action[object](Startup), "");