/*
	$Id: SettingsForm.cs 7 2009-12-26 02:19:18Z catwalk $
*/
using System;
using System.Configuration;
using System.Windows;
using System.Windows.Data;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.Reflection;

namespace Hiyoko.Forms{
	using WinForms = System.Windows.Forms;
	using Gdi = System.Drawing;
	
	public partial class SettingsForm : Window{
		private ApplicationSettings tempSettings;
		
		public SettingsForm(){
			this.InitializeComponent();
			
			this.tempSettings = new ApplicationSettings();
			CopySettings(Program.Settings, this.tempSettings);
			this.DataContext = this.tempSettings;
			this.accountPasswordEdit.Password = this.tempSettings.AccountPassword;
			this.tempSettings.PropertyChanged += delegate{
				this.accountPasswordEdit.Password = this.tempSettings.AccountPassword;
			};
			this.accountUsernameEdit.Focus();
		}
		
		private void OpenStartupScriptPath(object sender, EventArgs e){
			WinForms.OpenFileDialog dlg = new WinForms.OpenFileDialog();
			dlg.Filter = "Pyt@C|*.py";
			dlg.DefaultExt = "py";
			dlg.CheckPathExists = false;
			dlg.CheckFileExists = false;
			if(dlg.ShowDialog() == WinForms.DialogResult.OK){
				this.startupScriptPathEdit.Text = dlg.FileName;
			}
		}
		
		private void Close_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Close_Execute(object target, ExecutedRoutedEventArgs e){
			this.Close();
		}
		
		private void Save_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Save_Execute(object target, ExecutedRoutedEventArgs e){
			this.tempSettings.AccountPassword = this.accountPasswordEdit.Password;
			CopySettings(this.tempSettings, Program.Settings);
			Program.Settings.Save();
			this.Close();
		}
		
		private void Reset_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Reset_Execute(object target, ExecutedRoutedEventArgs e){
			if(MessageBox.Show("ݒlɖ߂Ă낵łH", "ݒ̏", MessageBoxButton.YesNo) == MessageBoxResult.Yes){
				this.tempSettings.Reset();
			}
		}
		
		private void DateTimeFormatUrl_Click(object sender, EventArgs e){
			System.Diagnostics.Process.Start("http://msdn.microsoft.com/ja-jp/library/8kb3ddd4.aspx");
		}
		
		private static void CopySettings(ApplicationSettingsBase source, ApplicationSettingsBase dest){
			foreach(SettingsProperty prop in source.Properties){
				dest[prop.Name] = source[prop.Name];
			}
		}
	}
}