/*
	$Id: Settings.cs 6 2009-12-26 00:58:57Z catwalk $
*/
using System;
using System.Configuration;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Windows;
using System.Windows.Media;

namespace Hiyoko{
	public abstract class UpgradeOnceApplicationSettingBase : ApplicationSettingsBase{
		public UpgradeOnceApplicationSettingBase(){}
		public UpgradeOnceApplicationSettingBase(string key) : base(key){}
		
		[NoSettingsVersionUpgrade]
		[UserScopedSetting]
		[DefaultSettingValue("false")]
		public virtual bool IsUpgradedSettings{
			get{
				return (bool)this["IsUpgradedSettings"];
			}
			set{
				this["IsUpgradedSettings"] = value;
			}
		}
		
		protected override void OnSettingsLoaded(object sender, SettingsLoadedEventArgs e){
			base.OnSettingsLoaded(sender, e);
		}
		
		public void UpgradeOnce(){
			if(!this.IsUpgradedSettings){
				this.Upgrade();
				this.IsUpgradedSettings = true;
			}
		}
	}
	
	public class ApplicationSettings : UpgradeOnceApplicationSettingBase{
		public ApplicationSettings(){}
		public ApplicationSettings(string key) : base(key){}
		
		[UserScopedSetting]
		[DefaultSettingValue(null)]
		public string StartupScriptPath{
			get{
				return (string)this["StartupScriptPath"];
			}
			set{
				this["StartupScriptPath"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("15000")]
		public int ConnectionTimeout{
			get{
				return (int)this["ConnectionTimeout"];
			}
			set{
				this["ConnectionTimeout"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("")]
		public string AccountUsername{
			get{
				return (string)this["AccountUsername"];
			}
			set{
				this["AccountUsername"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("")]
		public string AccountPassword{
			get{
				return (string)this["AccountPassword"];
			}
			set{
				this["AccountPassword"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("yyyy-MM-dd ddd hh-mm-ss tt")]
		public string DateTimeFormat{
			get{
				return (string)this["DateTimeFormat"];
			}
			set{
				this["DateTimeFormat"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("true")]
		public bool IsResident{
			get{
				return (bool)this["IsResident"];
			}
			set{
				this["IsResident"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("true")]
		public bool IsAutoRefreshTimeline{
			get{
				return (bool)this["IsAutoRefreshTimeline"];
			}
			set{
				this["IsAutoRefreshTimeline"] = value;
			}
		}
		/*
		[UserScopedSetting]
		[DefaultSettingValue("60")]
		public int AutoRefreshTimelineInterval{
			get{
				return (int)this["AutoRefreshTimelineInterval"];
			}
			set{
				if(value < 60){
					throw new ArgumentOutOfRangeException();
				}
				this["AutoRefreshTimelineInterval"] = value;
			}
		}
		*/
		[UserScopedSetting]
		[DefaultSettingValue("true")]
		public bool IsUseUserColor{
			get{
				return (bool)this["IsUseUserColor"];
			}
			set{
				this["IsUseUserColor"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("20")]
		public int TimelineCount{
			get{
				return (int)this["TimelineCount"];
			}
			set{
				if((value < 1) && (value > 200)){
					throw new ArgumentOutOfRangeException();
				}
				this["TimelineCount"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("")]
		public DateTime LatestTimelineStatusDate{
			get{
				return (DateTime)this["LatestTimelineStatusDate"];
			}
			set{
				this["LatestTimelineStatusDate"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("64")]
		public int OutputItemLimitCount{
			get{
				return (int)this["OutputItemLimitCount"];
			}
			set{
				if(value <= 0){
					throw new ArgumentOutOfRangeException();
				}
				this["OutputItemLimitCount"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("64")]
		public GridLength OutputListRowHeight{
			get{
				return (GridLength)this["OutputListRowHeight"];
			}
			set{
				this["OutputListRowHeight"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("false")]
		public bool IsHideOnMinimized{
			get{
				return (bool)this["IsHideOnMinimized"];
			}
			set{
				this["IsHideOnMinimized"] = value;
			}
		}
	}
	
	/// <summary>
	/// EChE̐ݒNX
	/// </summary>
	public class WindowSettings : UpgradeOnceApplicationSettingBase{
		public WindowSettings(){}
		public WindowSettings(string key) : base(key){}
		
		[UserScopedSetting]
		[DefaultSettingValue("0, 0, 640, 480")]
		public Rect RestoreBounds{
			get{
				return (Rect)this["RestoreBounds"];
			}
			set{
				this["RestoreBounds"] = value;
			}
		}
		
		[UserScopedSetting]
		[DefaultSettingValue("Normal")]
		public WindowState WindowState{
			get{
				return (WindowState)this["WindowState"];
			}
			set{
				this["WindowState"] = value;
			}
		}
	}
}